<?php

//Session Start
session_start();

include "config/init.php";
include "system/bank/bank-index.php";
include "system/bank_test/lr_func_bank_api.php";


include "template/header.php";

//Main Header
include "template/main-header.php";

//Left side column. contains the logo and sidebar
include "template/main-sidebar.php";

if(isset($_POST['bankInfo'])){
    $accNumber = html_filter($dbc,$_POST['accNumber']);
    $country = html_filter($dbc,$_POST['countryCode']);
	
	if($country=="gh"){
	$balance = bank_get_account_info($accNumber);	
	$result = "GHC".' '.moneyFormat2($balance['availableBal']);
	$data = bank_get_account_transactions_app($accNumber);
	$data1	 = $data['9']['postingDate'];
	}else{
	 $balance = lr_bank_get_account_info($accNumber);
	 $result = $balance['currency'].' '.moneyFormat2($balance['availableBal']);
	 $data = lr_bank_get_account_transactions_app($accNumber);	
	}
    
	//postingDate acctLink contraAccount transactionDetails documentRef currency branch amtSign amt
}

?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Customer Bank Account Info [Account Name: <?=$balance['accountName']?>][Account #: <?=$accNumber?>][Account Balance: <?=$result?>]
        </h1>
        <ol class="breadcrumb">
            <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active"> Customer Bank Account Info</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
       <div class="row">
            <div class="col-md-4">	
                <?php
                    if(isset($result)){
					//var_dump($balance);
					}
				
                ?>
                <div class="panel panel-default">
                    <div class="panel-heading">Customer Bank Account Info</div>
                    <div class="panel-body">
                        <form method="post" role="form">
                            <div class="form-group">
                                <label for="accNumber">Enter Bank Account Number</label>
                                <input type="text" name="accNumber" id="number" class="form-control" required placeholder="1003002030001">
                            </div>
                            <div class="form-group">
                                <label for="countryCode">Select Institution</label>
                                <select class="form-control staff_block" required name="countryCode" id="countryCode">
                                    <option value="">Select...</option>
									
									<?php 
				if($_SESSION[userCountry]=="gh"){
					
				?>
                                    <option value="gh">GN SAVINGS GHANA</option>
									
									<?php
									}
									?>
									
							<?php 
				if($_SESSION[userCountry]=="lr" or $_SESSION[userCountry]=="lr1"){
					
				?>		
									
									<option value="lr">GN BANK LIBERIA</option>
									<?php 
									}
									?>
									
                                </select>
                            </div>
                            <button type="submit" class="btn btn-primary btn-block" name="bankInfo">Get Info</button>
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-md-8">
		   
		 <div class="tab-pane" id="airtime">
                            <div class="box box-danger">
                                <div class="box-header with-border">Bank Account Statement (Last 10 Transactions)</div>
                                <div class="box-body">
                                    <table class="table table-striped" id="t3">
                                        <thead>
                                        <tr>
                                            <th>Date Time</th>
                                            <th>Customer Account #</th>
                                            <th>Contra Account #</th>
                                            <th>Document Ref</th>
                                            <th>Amount</th>
                                            <th>Transaction Type</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php
										//postingDate acctLink contraAccount transactionDetails documentRef currency branch amtSign amt
											
                                        $statement = $data;
                                        foreach($statement as $value){
                                           
                                            ?>
                                            <tr>
                                                <td><?=$value['postingDate'] ?></td>
                                                <td><?=$value['acctLink'] ?></td>
                                                <td><?=$value['contraAccount'] ?></td>
                                                <td><?=$value['documentRef'] ?></td>
                                                <td><?=$value['currency']?> <?=moneyFormat($value['amt']) ?></td>
                                                <td><?=$value['amtSign'] ?></td>
                                            </tr>
                                            <?php
                                        }
                                        ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>  
		   
		   </div>
       </div>
    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<?php include "template/footer.php"?>


