<?php
include "../functions/func_misc.php";
include "../functions/func_cus_account.php";
include "../functions/func_customer.php";
include "../functions/func_payglobal_voucher.php";
include "../functions/func_pricing_policy.php";
include "../functions/func_send_receive_money.php";
include "../functions/func_transactions.php";
include "../functions/func_commission.php";
include "../functions/func_token.php";
include "../functions/func_global_account.php";
include "../functions/func_notification.php";
include "../functions/func_viewquery.php";
include "../functions/func_system.php";
include "../functions/func_report.php";
include "../../system/airtime/airtime.php";
include "../../system/bank/bank-index.php";
include "../../../config/connection.php";
include "../../system/zenith/func_card.php";
include "../../system/hubtel/hubtel_func.php";

$response = array();

if (isset($_SERVER['HTTP_KIV'], $_SERVER['HTTP_KSP'])) {
    $kiv = $_SERVER['HTTP_KIV'];
    $ksp = $_SERVER['HTTP_KSP'];
    $source = $_SERVER['HTTP_BBP']; // 0 FOR ANDROID AND 1 FOR IOS
    $currentVersion = $_SERVER['HTTP_CURRENT']; // 2.1
    $appNumber = $_SERVER['HTTP_APPNUM']; // app number

    $keyCode1 = $_SERVER['HTTP_KEYCODE'];


    $kivHash = passwordHash($kiv . $keyCode1, $mySalt);
    $kspHash = passwordHash($ksp . $keyCode1, $mySalt);

    if (check_header_auth($dbc, $kivHash, $kspHash)) {
        if($currentVersion == "2.1") {
            if (isset($_REQUEST['action'])) {
                if ($_SERVER['REQUEST_METHOD'] == 'POST') {
                    $action = $_REQUEST['action'];
                    switch ($action) {
                        CASE 500:
                            //Firebase id creator
                            $fireToken = html_filter($dbc, $_REQUEST['fireToken']);
                            $phoneNum = html_filter($dbc, $_REQUEST['phoneNum']);
                            if($source == '1'){
                                $phoneNum = "+".html_filter($dbc, $_REQUEST['phoneNum']);
                            }
                            if (check_if_number_exist($dbc, $phoneNum)) {

                                $q = mysqli_query($dbc, "UPDATE customer_tbl SET firebaseKey = '$fireToken' WHERE phoneNum = '$phoneNum'");
                                if ($q) {
                                    echo "SUCCESSFUL";

                                } else {
                                    echo "UNSUCCESSFUL";
                                }
                            }
                            break;
                        case 700:

                            $phoneNum = html_filter($dbc, $_REQUEST['recipient']);
                            if($source == '1'){
                                $phoneNum = "+".html_filter($dbc, $_REQUEST['recipient']);
                            }
                            if (check_if_number_exist($dbc, $phoneNum)) {
                                $cus = get_customer_by_phoneNum($dbc, $phoneNum);
                                $fullName = $cus['fullName'];
                                echo $fullName;
                            } else {
                                //Call token generator
                                $token = tokenGenerator();
                                echo $token;
                            }

                            break;
                        case 701:

                            $phoneNum = html_filter($dbc, $_REQUEST['phoneNum']);
                            $countryCode = html_filter($dbc, $_REQUEST['countryCode']);
                            $countryData = get_country_code_with_currency($dbc, $countryCode);

                            $newPhoneNum = $countryData['callCode'] . $phoneNum;
                            $code = genSMSCode();
                            $message = "Please use this code {$code} to verify your PayGlobal Account";
                            if($source == '1'){
                                $message = "Please tap the following link to activate PayGlobal Account:payglobal://?contact={$code}";
                            }
                            sendSMS($newPhoneNum, $message);
                            echo trim($code);
                            break;

                        case 501:
                            $platform = html_filter($dbc, $_REQUEST['platform']);
                            if($platform == 'ios'){
                                $res = array();
                                $res['review'] = 'active';
                                $res['statusCode'] = 200;
                                echo json_encode($res);
                            }
                            break;

                        case 702:
                            $from = html_filter($dbc, $_REQUEST['from']);
                            $to = html_filter($dbc, $_REQUEST['to']);
                            $phoneNum = html_filter($dbc, $_REQUEST['phoneNum']);
                            $email = html_filter($dbc, $_REQUEST['email']);
                            if($source == '1'){
                                $phoneNum = "+".html_filter($dbc, $_REQUEST['phoneNum']);
                            }

                            if (check_if_number_exist($dbc, $phoneNum)) {
                                if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
                                    $customerData = get_customer_by_phoneNum($dbc, $phoneNum);
                                    // $data = get_all_transaction_by_dateRate($dbc,$customerData['id'],$from,$to);

                                    echo "SUCCESSFUL";
                                } else {
                                    echo 'WRONG_EMAIL';
                                }

                            } else {
                                echo 'UNSUCCESSFUL';
                            }
                            break;
                        case 900:
                            $phoneNum = html_filter($dbc, $_REQUEST['rcontact1']);
                            $password = passwordHash($_REQUEST['pword'], $mySalt);
                            $simSID = html_filter($dbc, $_REQUEST['simsid']);
                            $simSerial = html_filter($dbc, $_REQUEST['simserial']);
                            $keyCode = html_filter($dbc, $_REQUEST['keyCode']);
                            $phoneIMEI = html_filter($dbc, $_REQUEST['pid']);
                            $countryCode = html_filter($dbc, $_REQUEST['countryCode']);

                            $countryData = get_country_code_with_currency($dbc, $countryCode);
                            //$phoneNum = $countryData['callCode'].$phoneNum;
                            //$phoneNum = phone_format($phoneNum);

                            if($source == '1'){
                                $phoneNum = "+".html_filter($dbc, $_REQUEST['rcontact1']);
                            }

                            if (check_if_number_exist($dbc, $phoneNum)) {
                                if (verify_password($dbc, $password, $phoneNum)) {
                                    if (update_keyCode_variables($dbc, $keyCode, $phoneIMEI, $simSID, $simSerial, $phoneNum)) {
                                        $vvv1 = "PHONE_EXISTS";
                                        //echo "(".$countryData['callCode']."/".$vvv1."*".$countryData['currency'].")";
                                        echo "({$countryData['callCode']}/{$vvv1}*{$countryData['currency']})";
                                    }
                                } else {
                                    echo "INCORRECT_PASSWORD";
                                }

                            }
                            break;
                        case 901:
                            //Registration for the first time on smart phone
                            $phoneNum = html_filter($dbc, $_REQUEST['phoneNum']);
                            $password = passwordHash($_REQUEST['password'], $mySalt);
                            $fullName = html_filter($dbc, $_REQUEST['fullName']);
                            $dob = html_filter($dbc, $_REQUEST['dob']);
                            $email = html_filter($dbc, $_REQUEST['email']);

                            $countryCode = html_filter($dbc, $_REQUEST['countryCode']);
                            $phoneIMEI = html_filter($dbc, $_REQUEST['pid']);
                            $simSID = html_filter($dbc, $_REQUEST['simsid']);
                            $simSerial = html_filter($dbc, $_REQUEST['simSerial']);
                            $keyCode = html_filter($dbc, $_REQUEST['keyCode']);

                            $countryData = get_country_code_with_currency($dbc, $countryCode);
                            $phoneNum = $countryData['callCode'] . $phoneNum;


                            if (check_if_number_exist($dbc, $phoneNum)) {
                                echo "PHONE_EXISTS";

                            } else {
                                if (add_customer_by_smartPhone($dbc, $phoneNum, $password, $email, $fullName, $dob, $phoneIMEI, $keyCode, $simSerial, $simSID, $countryCode)) {
                                    $vvv = "CORRECT";
                                    echo "(" . $countryData['callCode'] . "/" . $vvv . "*" . $countryData['currency'] . ")";
                                } else {
                                    echo("INCORRECT_REGISTRATION");
                                }
                            }
                            break;
                        case 902:
                            //Restore Registered Account

                            $phoneNum = html_filter($dbc, $_REQUEST['phoneNum']);
                            $keyCode = html_filter($dbc, $_REQUEST['keyCode']);
                            $countryCode = html_filter($dbc, $_REQUEST['countryCode']);
                            $password = passwordHash($_REQUEST['password'], $mySalt);

                            $countryData = get_country_code_with_currency($dbc, $countryCode);
                            $phoneNum = $countryData['callCode'] . $phoneNum;

                            if (check_phoneNum_and_password($dbc, $phoneNum, $password)) {
                                if (update_key_code($dbc, $keyCode, $phoneNum)) {
                                    echo "(SUCCESSFUL/{$countryData['callCode']}*{$countryData['currency']})";
                                } else {
                                    echo "UNSUCCESSFUL1";
                                }
                            } else {
                                echo "UNSUCCESSFUL2";
                            }
                            break;
                        case 911:
                            //Migration Restore USSD Registered Account

                            $phoneNum = html_filter($dbc, $_REQUEST['phoneNum']);
                            $keyCode = html_filter($dbc, $_REQUEST['keyCode']);
                            $countryCode = html_filter($dbc, $_REQUEST['countryCode']);
                            $password = passwordHash($_REQUEST['password'], $mySalt);
                            $pin = html_filter($dbc, $_REQUEST['pin']);
                            $phoneIMEI = html_filter($dbc, $_REQUEST['pid']);
                            $simSID = html_filter($dbc, $_REQUEST['simsid']);
                            $simSerial = html_filter($dbc, $_REQUEST['simSerial']);

                            $countryData = get_country_code_with_currency($dbc, $countryCode);
                            $phoneNum = $countryData['callCode'] . $phoneNum;

                            if (check_phoneNum_and_pin($dbc, $phoneNum, trim($pin))) {
                                if (restore_ussd_account_on_smart($dbc, $phoneNum, $keyCode, $password, $simSID, $simSerial, $phoneIMEI)) {
                                    echo "(SUCCESSFUL/{$countryData['callCode']}*{$countryData['currency']})";
                                } else {
                                    echo "UNSUCCESSFUL";
                                }
                            } else {
                                echo "UNSUCCESSFUL";
                            }
                            break;
                        case 903:
                            // Load money using Pay Global Voucher
                            $phoneNum = html_filter($dbc, $_REQUEST['rcontact']);
                            if($source == '1'){
                                $phoneNum = "+".html_filter($dbc, $_REQUEST['rcontact']);
                            }
                            $amount = html_filter($dbc, $_REQUEST['ramount']);
                            $voucherCode = html_filter($dbc, $_REQUEST['voucherCode']);
                            $keyCode = html_filter($dbc, $_REQUEST['keyCode']);
                            $countryCode = html_filter($dbc, $_REQUEST['countryCode']);
                            if (check_voucher_exist($dbc, $voucherCode, $amount, $countryCode)) {
                                if (check_phoneNum_and_keyCode($dbc, $phoneNum, $keyCode)) {
                                    if (recharge_with_voucher($dbc, $phoneNum, $voucherCode)) {
                                        echo("VOUCHER_ADD");
                                    } else {
                                        echo("VOUCHER_ADDITION_FAILED");
                                    }
                                } else {
                                    echo("NOT_VERIFIED_USER");
                                }
                            } else {
                                echo("WRONG_VOUCHER");
                            }
                            break;

                        CASE 908:
                            // Token, Receive money from token
                            $phoneNum = html_filter($dbc, $_REQUEST['recipientNumber']);
                            $keyCode = html_filter($dbc, $_REQUEST['keyCode']);
                            $token = trim(html_filter($dbc, $_REQUEST['token']));
                            $tokenPin = trim(html_filter($dbc, $_REQUEST['pin']));
                            if($source == '1'){
                                $phoneNum = "+".html_filter($dbc, $_REQUEST['recipientNumber']);
                            }

                            $recipientData = get_customer_by_phoneNum($dbc, $phoneNum);
                            if (check_phoneNum_and_keyCode($dbc, $phoneNum, $keyCode)) {
                                if (check_if_number_exist_as_agent($dbc, $phoneNum)) {
                                    if (check_token_exist($dbc, $token, $tokenPin, $recipientData['countryCode'])) {

                                        if (check_if_token_used($dbc, $token)) {
                                            $tokenData = get_token_mgt_by_token_pin($dbc, $token, $tokenPin);
                                            $senderData = get_customer_by_id($dbc, $tokenData['senderID']);

                                            $transactionData = get_main_transaction_by_transaction_uid($dbc, $tokenData['transaction_uid']);
                                            if(add_funds($dbc,$recipientData['id'],$transactionData['recipientAmount'])){
                                                $pricing = get_pricing_by_id($dbc, $transactionData['pricing_id']);
                                                $recipientAcc = get_cus_account_info_by_customerID($dbc, $recipientData['id']);
                                                if (update_transaction_ussd_by_transaction_id($dbc, $recipientData, $transactionData['transaction_uid'], $recipientAcc['balance'])) {
                                                    if (update_token_mgt_after_redraws($dbc, $recipientData, $transactionData['transaction_uid'])) {
                                                        $agentFee = $transactionData['fee'] * $pricing['recipientCommission'];
                                                        $fee = $transactionData['exRate'] * $agentFee;
                                                        $newTransactionData = get_main_transaction_by_transaction_uid($dbc, $tokenData['transaction_uid']);
                                                        if (add_agent_commission($dbc, $newTransactionData, $fee, $recipientData['countryCode'])) {
                                                            echo "SUCCESSFUL";
                                                            $message = "You have received an amount of {$newTransactionData['recipientAmount']} from a token. Transaction ID is {$newTransactionData['transaction_uid']}";
                                                            sendSMS($phoneNum, $message);
                                                        }
                                                    }
                                                }

                                            } else{
                                                echo "UNSUCCESSFUL";
                                            }
                                        } else {
                                            echo "ALREADY_CLAIMED";
                                        }
                                    } else {
                                        echo "WRONG_TOKEN";
                                    }
                                } else {
                                    echo "UNAUTHORISED_USER";
                                }
                            } else {
                                echo("Sorry, Error authenticating user!");
                            }
                            // End of token Retrieval
                            break;

                        CASE 910:
                            // Airtime TopUp
                            $sendPhoneNum = html_filter($dbc, $_REQUEST['senderPhone']);
                            if($source == '1'){
                                $sendPhoneNum = "+".html_filter($dbc, $_REQUEST['senderPhone']);
                            }
                            $airtimeNumber = html_filter($dbc, $_REQUEST['recipientPhone']);
                            $country = html_filter($dbc, $_REQUEST['country']);
                            $network = html_filter($dbc, $_REQUEST['network']);
                            $amount = html_filter($dbc, $_REQUEST['amount']);
                            $keyCode = html_filter($dbc, $_REQUEST['keyCode']);
                            $transactionType = 'AIRTIME';

                            if (check_phoneNum_and_keyCode($dbc, $sendPhoneNum, $keyCode)) {
                                $senderData = get_customer_by_phoneNum($dbc, $sendPhoneNum);
                                $networkData = get_airtime_network($network);
                                $senderAcc = get_cus_account_info_by_customerID($dbc, $senderData['id']);
                                $transaction_uid = genTransactionID();
                                $airTimeAccData = get_customer_by_phoneNum($dbc,"+233772000000");
                                if ($senderData['countryCode'] == 'gh') {
                                    if ($senderAcc['balance'] >= $amount) {
                                        $response = buy_airtime($airtimeNumber, $amount, $networkData, $transaction_uid);
                                        if ($response['status'] == "OK") {
                                            if (redraw_funds($dbc, $senderData['id'], $amount)) {
                                                if(add_funds($dbc,$airTimeAccData['id'],$amount)) {
                                                    $senderAcc = get_cus_account_info_by_customerID($dbc, $senderData['id']);
                                                    $airtimeAcc = get_cus_account_info_by_customerID($dbc, $airTimeAccData['id']);
                                                    if (add_airtime_transaction_by_smartPhone($dbc, $senderData['id'],$airTimeAccData['id'],$airtimeNumber, $amount,$amount, $senderData['countryCode'],$airTimeAccData['countryCode'], $network, $transaction_uid, $response['balance'], $senderAcc['balance'],$airtimeAcc['balance'])) {
                                                        /*
                                                        * Agents gets commission when sells airtime
                                                        */
                                                        if ($senderData['countryCode'] == 'gh' AND $senderData['accountType'] == 2 OR $senderData['accountType'] == 4) {
                                                            $fee = $amount * 0.02;

                                                            $transactionData = array();
                                                            $transactionData['recipientID'] = $senderData['id'];
                                                            $transactionData['senderID'] = $senderData['id'];
                                                            $transactionData['transactionTypes'] = 'AIRTIME';
                                                            $transactionData['transaction_uid'] = $transaction_uid;
                                                            if (add_agent_commission($dbc, $transactionData, $fee, $senderData['countryCode'])) {
                                                                add_airtimeExpense($dbc, $senderData['countryCode'], $fee);

                                                            }

                                                        }

                                                        /*
                                                         * End of agents get commission
                                                         */

                                                        $message = "You have purchased {$amount} value of Airtime for {$airtimeNumber}";
                                                        sendSMS($senderData['phoneNum'],$message);

                                                        if ($senderData['firebaseKey'] != '') {
                                                            firebaseCall($senderData['firebaseKey'],  $message);
                                                        }

                                                        echo "SUCCESSFUL";
                                                    } else {
                                                        echo "UNSUCCESSFUL1";
                                                    }
                                                } else{
                                                    echo "UNSUCCESSFUL1";
                                                }
                                            } else {
                                                echo "UNSUCCESSFUL3";
                                            }
                                        } else {
                                            echo 'TRANSACTION_ERROR';
                                        }

                                    } else {
                                        echo 'LOW_BALANCE';
                                    }
                                } else {
                                    // International to Ghana Airtime purchase
                                    $rate = get_conversion_rate($dbc,$senderData['countryCode'],'gh');
                                    $newAmount = $amount * $rate;
                                    if ($senderAcc['balance'] >= $newAmount) {
                                        $response = buy_airtime($airtimeNumber, $newAmount, $networkData, $transaction_uid);
                                        if ($response['status'] == "OK") {
                                            if (redraw_funds($dbc, $senderData['id'], $amount)) {
                                                if(add_funds($dbc,$airTimeAccData['id'],$newAmount)) {
                                                    if(transcription($dbc,$senderData,$airTimeAccData,$transactionType,$amount,'',$transaction_uid)) {
                                                        $senderAcc = get_cus_account_info_by_customerID($dbc, $senderData['id']);
                                                        $airtimeAcc = get_cus_account_info_by_customerID($dbc, $airTimeAccData['id']);
                                                        if (add_airtime_transaction_by_smartPhone($dbc, $senderData['id'], $airTimeAccData['id'], $airtimeNumber,$amount, $newAmount, $senderData['countryCode'], $airTimeAccData['countryCode'], $network, $transaction_uid, $response['balance'], $senderAcc['balance'], $airtimeAcc['balance'])) {
                                                            /*
                                                            * Agents gets commission when sells airtime
                                                            */
                                                            /*if ($senderData['countryCode'] == 'gh' AND $senderData['accountType'] == 2 OR $senderData['accountType'] == 4) {
                                                                $fee = $amount * 0.02;

                                                                $transactionData = array();
                                                                $transactionData['recipientID'] = $senderData['id'];
                                                                $transactionData['senderID'] = $senderData['id'];
                                                                $transactionData['transactionTypes'] = 'AIRTIME';
                                                                $transactionData['transaction_uid'] = $transaction_uid;
                                                                if (add_agent_commission($dbc, $transactionData, $fee, $senderData['countryCode'])) {
                                                                    add_airtimeExpense($dbc, $senderData['countryCode'], $fee);

                                                                }

                                                            }
                                                            */

                                                            /*
                                                             * End of agents get commission
                                                             */
                                                            $message = "You have purchased {$amount} value of Airtime for {$airtimeNumber}";
                                                            sendSMS($senderData['phoneNum'],$message);

                                                            if ($senderData['firebaseKey'] != '') {
                                                                firebaseCall($senderData['firebaseKey'],  $message);
                                                            }

                                                            echo "SUCCESSFUL";
                                                        } else {
                                                            echo "UNSUCCESSFUL1";
                                                        }
                                                    }
                                                } else{
                                                    echo "UNSUCCESSFUL1";
                                                }
                                            } else {
                                                echo "UNSUCCESSFUL3";
                                            }
                                        } else {
                                            echo 'TRANSACTION_ERROR';
                                        }

                                    } else {
                                        echo 'LOW_BALANCE';
                                    }

                                }

                            } else {
                                echo("Sorry, Error authenticating user!");
                            }

                            break;

                        CASE 914:
                            if (isset($_REQUEST['status'])) {
                                /*
                                 * WALLET to GN Bank Account
                                 */
                                $status = html_filter($dbc, $_REQUEST['status']);
                                if ($status == true) {
                                    $fee = html_filter($dbc, $_REQUEST['fee']);
                                    $transaction_uid = html_filter($dbc, $_REQUEST['transaction_uid']);
                                    $transactionData = get_bank_transaction_by_transaction_uid($dbc, $transaction_uid);
                                    $senderData = get_customer_by_id($dbc, $transactionData['senderID']);
                                    $recipientData = get_customer_by_id($dbc, $transactionData['recipientID']);

                                    $validate = bank_validate_accountNumber($transactionData['senderBankAccount']);
                                    $comment = "GNM WTB ({$senderData['fullName']} - {$senderData['phoneNum']}) TO ({$validate['accountName']})";
                                    if (redraw_funds($dbc, $senderData['id'], $transactionData['sendersAmount'])) {
                                        if (add_funds($dbc, $recipientData['id'], $transactionData['recipientAmount'])) {
                                            if(redraw_funds($dbc,$senderData['id'],$fee)) {
                                                $transactionData['senderCountryCode'] = $senderData['countryCode'];
                                                if (add_payGlobal_commission($dbc, $transactionData, $transactionData['fee'])) {
                                                    $senderAcc = get_cus_account_info_by_customerID($dbc, $senderData['id']);
                                                    $recipientAcc = get_cus_account_info_by_customerID($dbc, $recipientData['id']);
                                                    if (update_bank_transaction_before_api_call($dbc, $transaction_uid, $senderAcc['balance'])) {
                                                        $transferData = bank_transfer_funds($transactionData['recipientBankAccount'], $transactionData['senderBankAccount'], $transactionData['recipientAmount'], "0", $comment, $transactionData['foreignId']);
                                                        if ($transferData['comment'] == "Successful") {
                                                            if (update_bank_transaction_after_success($dbc, $transactionData['transaction_uid'], $transferData['foreignId'])) {
                                                                if(update_bank_transaction_balance($dbc,$transaction_uid,$recipientAcc['balance'],$senderAcc['balance'])) {
                                                                    $transactionData['senderCountryCode'] = "gh";
                                                                    $transactionData['transactionTypes'] = "WTB";
                                                                    $message = "{$transactionData['recipientAmount']} was transferred to {$transactionData['senderBankAccount']}, transaction ID: {$transactionData['transaction_uid']}";
                                                                    sendSMS($senderData['phoneNum'], $message);
                                                                    echo "SUCCESSFUL";
                                                                }
                                                            }
                                                        } else {

                                                            echo "UNSUCCESSFUL";
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    } else {
                                        echo "UNSUCCESSFUL";
                                    }

                                } else {
                                    echo "UNSUCCESSFUL";
                                }

                            } else {
                                $phoneNum = html_filter($dbc, $_REQUEST['phoneNum']);
                                if($source == '1'){
                                    $phoneNum = "+".html_filter($dbc, $_REQUEST['phoneNum']);
                                }
                                $keyCode = html_filter($dbc, $_REQUEST['keyCode']);
                                $amount = html_filter($dbc, $_REQUEST['Bamount']);
                                $accountNum = html_filter($dbc, $_REQUEST['accNum']);
                                if (check_phoneNum_and_keyCode($dbc, $phoneNum, $keyCode)) {
                                    $system_status = get_system_status_by_serviceType($dbc, "BANK");
                                    if ($system_status['status'] == 'ON') {
                                        $senderData = get_customer_by_phoneNum($dbc, $phoneNum);
                                        $recipientData = get_customer_by_phoneNum($dbc, "+233773000000");
                                        $validate = bank_validate_accountNumber($accountNum);
                                        if ($validate['comment'] == 'Successful') {
                                            /*$recipientData['uGroup'] = 2000;
                                            $senderData['uGroup'] = 2000;
                                            $recipientData['accountType'] = 2000;
                                            $senderData['accountType'] = 2000;*/
                                            $balance = check_for_enough_balance_on_WTB($dbc, $senderData, $recipientData, $amount, "WTB");
                                            if ($balance['status'] == true) {
                                                /*
                                                 * Check if customer is Agent or Super Agent. If any Charge no fee.
                                                 *
                                                $cusData = get_customer_by_id($dbc, $senderData['id']);
                                                if ($cusData['accountType'] == 2 OR $cusData['accountType'] == 4) {
                                                    $balance['fee'] = 0.00;
                                                    $balance['newAmount'] = $balance['exactAmount'];
                                                }
                                                *
                                                 * End of No fee for super agents and agents
                                                 */
                                                if (dailyKyc($dbc, $senderData['id'], $senderData['countryCode'], $balance['exactAmount'], $balance['fee'])) {
                                                    if (monthlyKyc($dbc, $senderData['id'], $senderData['countryCode'], $balance['exactAmount'], $balance['fee'])) {
                                                        $rate = get_conversion_rate($dbc, $senderData['countryCode'], $recipientData['countryCode']);
                                                        $recipientAmount = $balance['exactAmount'] * $rate;

                                                        if (add_bank_transaction_WTB_smart($dbc, $accountNum, $senderData, $recipientData, 'SMART', 'WTB', $balance, $recipientAmount)) {

                                                            echo "({$validate['accountName']}/{$balance['fee']}*{$balance['transaction_uid']}!{$balance['status']})";

                                                        } else {
                                                            echo "ERROR";
                                                        }
                                                    } else {
                                                        echo "MONTHLY_LIMIT";
                                                    }
                                                } else {
                                                    echo 'DAILY_LIMIT';
                                                }
                                            } else {
                                                echo "LOW_BALANCE";
                                            }
                                        } else {
                                            echo "WRONG_ACCOUNT_NUMBER";
                                        }
                                    }else{
                                        echo("Sorry, Error authenticating user!");
                                    }
                                } else {
                                    echo("Sorry, Error authenticating user!");
                                }
                            }
                            break;


                        CASE 932:
                            /*
                             * GN Bank Account to GN Bank Account
                             */
                            if (isset($_REQUEST['status'])) {
                                $status = html_filter($dbc, $_REQUEST['status']);
                                if ($status == true) {
                                    $fee = html_filter($dbc, $_REQUEST['fee']);
                                    $transaction_uid = html_filter($dbc, $_REQUEST['transaction_uid']);
                                    $transactionData = get_bank_transaction_by_transaction_uid($dbc, $transaction_uid);
                                    $senderData = get_customer_by_id($dbc, $transactionData['senderID']);

                                    $senderValidate = bank_validate_accountNumber($transactionData['senderBankAccount']);
                                    $recipientValidate = bank_validate_accountNumber($transactionData['recipientBankAccount']);
                                    $comment = "GNM BTB ({$senderValidate['accountName']}) TO ({$recipientValidate['accountName']})";
                                    $transferData = bank_transfer_funds($transactionData['senderBankAccount'], $transactionData['recipientBankAccount'], $transactionData['sendersAmount'], "0", $comment, $transactionData['foreignId']);
                                    if ($transferData['comment'] == "Successful") {

                                        $bankCommissionAccount = '1002111000708';
                                        $feeForeignId = genBankTransactionID_main();
                                        $feeTransfer = bank_transfer_funds($transactionData['senderBankAccount'], $bankCommissionAccount, $transactionData['fee'], "0", "GN MONEY FEE - BANK TO BANK - {$senderData['phoneNum']}", $feeForeignId);
                                        if ($feeTransfer['comment'] == "Successful") {
                                            if (add_bank_commission($dbc, $transactionData['senderID'], $transactionData['senderBankAccount'], $transactionData['recipientBankAccount'], $bankCommissionAccount, $transactionData['fee'], $transactionData['transaction_uid'], $feeTransfer['foreignId'], 'COMPLETED')) {
                                                if (update_bank_transaction_after_success($dbc, $transactionData['transaction_uid'], $transferData['foreignId'])) {
                                                    $message = "{$transactionData['recipientAmount']} was transferred to {$transactionData['recipientBankAccount']}, transaction ID: {$transactionData['transaction_uid']}";
                                                    sendSMS($senderData['phoneNum'], $message);
                                                    echo "SUCCESSFUL";
                                                }else {
                                                    echo "UNSUCCESSFUL12";
                                                }
                                            }else {
                                                echo "UNSUCCESSFUL13";
                                            }

                                        }else {
                                            echo "UNSUCCESSFUL14";
                                        }
                                    } else {
                                        echo "UNSUCCESSFUL";
                                    }
                                } else {
                                    echo "UNSUCCESSFUL2";
                                }
                            } else {
                                $phoneNum = html_filter($dbc, $_REQUEST['phoneNum']);
                                if($source == '1'){
                                    $phoneNum = "+".html_filter($dbc, $_REQUEST['phoneNum']);
                                }
                                $keyCode = html_filter($dbc, $_REQUEST['keyCode']);
                                $amount = html_filter($dbc, $_REQUEST['amount']);
                                $senderAcc = html_filter($dbc, $_REQUEST['senderAccount']);
                                $recipientAcc = html_filter($dbc, $_REQUEST['recipientAccount']);
                                $senderData = get_customer_by_phoneNum($dbc, $phoneNum);
                                if (check_phoneNum_and_keyCode($dbc, $phoneNum, $keyCode)) {

                                    $system_status = get_system_status_by_serviceType($dbc, "BANK");
                                    if ($system_status['status'] == 'ON') {
                                        $linked = bank_get_linked_accounts($phoneNum);
                                        if ($linked['status'] != 'NOT_LINKED') {
                                            $linkedArray = array($linked['account1'], $linked['account2'], $linked['account3']);
                                            if (in_array($senderAcc, $linkedArray)) {

                                                $recipientData = array();
                                                $recipientData['uGroup'] = 2000;
                                                $senderData['uGroup'] = 2000;
                                                $recipientData['accountType'] = 2000;
                                                $senderData['accountType'] = 2000;
                                                $feeData = check_for_enough_balance_on_BTB($dbc, $senderData, $recipientData, $amount, 'BTB');
                                                $balance = bank_balance_request($senderAcc);
                                                if ($balance['availableBal'] >= $feeData['newAmount']) {
                                                    $validate = bank_validate_accountNumber($recipientAcc);
                                                    if ($validate['comment'] == 'Successful') {
                                                        $transaction_uid = genTransactionID();
                                                        if (add_bank_transaction_BTB_smart($dbc, $senderData, $amount, $senderAcc, $recipientAcc, 'SMART', 'BTB', $transaction_uid, $feeData['fee'])) {
                                                            $fee = $feeData['fee'];
                                                            $status = true;
                                                            echo "({$validate['accountName']}/{$fee}*{$transaction_uid}!{$status})";
                                                        }
                                                    } else {
                                                        echo "INVALID_RECIPIENT_ACCOUNT";
                                                    }

                                                } else {
                                                    echo "LOW_BALANCE";
                                                }
                                            } else {
                                                echo "INVALID_SENDER_ACCOUNT";
                                            }
                                        } else {
                                            echo "NOT_LINKED";
                                        }
                                    }else{
                                        echo "Sorry, Error authenticating user!";
                                    }
                                } else {
                                    echo("Sorry, Error authenticating user!");
                                }
                            }
                            break;

                        CASE 904:
                            /*
                             * GN Bank Account to payGlobal Wallet
                             */
                            if (isset($_REQUEST['status'])) {
                                $status = html_filter($dbc, $_REQUEST['status']);
                                if ($status == true) {
                                    $fee = html_filter($dbc, $_REQUEST['fee']);
                                    $transaction_uid = html_filter($dbc, $_REQUEST['transaction_uid']);
                                    $transactionData = get_bank_transaction_by_transaction_uid($dbc, $transaction_uid);
                                    $recipientData = get_customer_by_id($dbc, $transactionData['recipientID']);
                                    $senderData = get_customer_by_id($dbc, $transactionData['senderID']);
                                    $totalAmount = $transactionData['fee'] + $transactionData['recipientAmount'];
                                    $validate = bank_validate_accountNumber($transactionData['recipientBankAccount']);
                                    $comment = "GNM BTW ({$validate['accountName']}) TO ({$recipientData['fullName']} - {$recipientData['phoneNum']})";
                                    if (update_bank_transaction_before_api_call($dbc, $transaction_uid, 0)) {
                                        $transferData = bank_transfer_funds($transactionData['recipientBankAccount'], $transactionData['senderBankAccount'], $totalAmount, "0", $comment, $transactionData['foreignId']);
                                        if ($transferData['comment'] == "Successful") {
                                            if (redraw_funds($dbc, $senderData['id'], $transactionData['sendersAmount'])) {
                                                if (add_funds($dbc, $recipientData['id'], $transactionData['recipientAmount'])) {
                                                    $all_transactionData = get_bank_transaction_by_transaction_uid($dbc, $transactionData['transaction_uid']);
                                                    //$all_transactionData['senderID'] = $transactionData['recipientID'];
                                                    $all_transactionData['senderCountryCode'] = $senderData['countryCode'];
                                                    $all_transactionData['transactionTypes'] = $transactionData['serviceType'];
                                                    if (add_payGlobal_commission($dbc, $all_transactionData, $all_transactionData['fee'])) {
                                                        if (update_bank_transaction_after_success($dbc, $transactionData['transaction_uid'], $transferData['foreignId'])) {
                                                            $recipientAcc = get_cus_account_info_by_customerID($dbc, $recipientData['id']);
                                                            $senderAcc = get_cus_account_info_by_customerID($dbc, $senderData['id']);
                                                            if (update_bank_transaction_balance($dbc, $transactionData['transaction_uid'], $recipientAcc['balance'],$senderAcc['balance'])) {
                                                                $message = "{$transactionData['recipientAmount']} was transferred to your wallet, transaction ID: {$transactionData['transaction_uid']}";
                                                                sendSMS($recipientData['phoneNum'], $message);
                                                                echo "SUCCESSFUL";
                                                            }
                                                        }
                                                    }

                                                }
                                            }

                                        } else {
                                            echo "UNSUCCESSFUL";
                                        }

                                    }
                                } else {
                                    echo "UNSUCCESSFUL2";
                                }
                            } else {
                                $phoneNum = html_filter($dbc, $_REQUEST['phoneNum']);
                                if($source == '1'){
                                    $phoneNum = "+".html_filter($dbc, $_REQUEST['phoneNum']);
                                }
                                $keyCode = html_filter($dbc, $_REQUEST['keyCode']);
                                $amount = html_filter($dbc, $_REQUEST['amount']);
                                $recipientAcc = html_filter($dbc, $_REQUEST['senderAccount']);
                                $recipientData = get_customer_by_phoneNum($dbc, $phoneNum);

                                $senderData = get_customer_by_phoneNum($dbc,'+233773000000');

                                /*$recipientData['uGroup'] = 2000;
                                $senderData['uGroup'] = 2000;
                                $recipientData['accountType'] = 2000;
                                $senderData['accountType'] = 2000;*/

                                if (check_phoneNum_and_keyCode($dbc, $phoneNum, $keyCode)) {
                                    $system_status = get_system_status_by_serviceType($dbc, "BANK");
                                    if ($system_status['status'] == 'ON') {
                                        $linked = bank_get_linked_accounts($phoneNum);
                                        if ($linked['status'] != 'NOT_LINKED') {
                                            $linkedArray = array($linked['account1'], $linked['account2'], $linked['account3']);
                                            if (in_array($recipientAcc, $linkedArray)) {
                                                $balance = bank_balance_request($recipientAcc);
                                                $data = check_for_enough_balance_on_BTW($dbc, $senderData, $recipientData, $amount, 'BTW');
                                                if ($balance['availableBal'] >= $data['newAmount']) {
                                                    $validate = bank_validate_accountNumber($recipientAcc);
                                                    if ($validate['comment'] == 'Successful') {
                                                        $transaction_uid = genTransactionID();
                                                        /*
                                                         * Check if customer is Agent or Super Agent. If any Charge no fee.
                                                         *
                                                        $cusData = get_customer_by_id($dbc,$recipientData['id']);
                                                        if ($cusData['accountType'] == 2 OR $cusData['accountType'] == 4) {
                                                            $data['fee'] = 0.00;
                                                            $data['newAmount'] = $data['exactAmount'];
                                                        }
                                                        *
                                                         * End of No fee for super agents and agents
                                                         */

                                                        if (add_bank_transaction_BTW_smart($dbc, $senderData, $recipientData, $data['exactAmount'], $recipientAcc, 'SMART', 'BTW', $transaction_uid, $data['fee'])) {
                                                            $fee = $data['fee'];
                                                            $status = true;
                                                            echo "({$validate['accountName']}/{$fee}*{$transaction_uid}!{$status})";
                                                        } else {
                                                            echo 'ERROR';
                                                        };
                                                    } else {
                                                        echo "INVALID_SENDER_ACCOUNT";
                                                    }
                                                } else {
                                                    echo "LOW_BALANCE";
                                                }
                                            } else {
                                                echo "INVALID_SENDER_ACCOUNT";
                                            }
                                        } else {
                                            echo "NOT_LINKED";
                                        }
                                    }else{
                                        echo("Sorry, Error authenticating user!");
                                    }
                                } else {
                                    echo("Sorry, Error authenticating user!");
                                }
                            }
                            break;
                        CASE 925:
                            // Activate USSD Code
                            $phoneNum = html_filter($dbc, $_REQUEST['rcontact1']);
                            if($source == '1'){
                                $phoneNum = "+".html_filter($dbc, $_REQUEST['rcontact1']);
                            }
                            $password = passwordHash($_REQUEST['password'], $mySalt);
                            $ussdCode = passwordHash($_REQUEST['ussdCode'], $mySalt);
                            if (check_phoneNum_and_password($dbc, $phoneNum, $password)) {
                                if (update_ussdCode($dbc, $phoneNum, $ussdCode)) {
                                    echo "USSD_ACTIVATED";
                                } else {
                                    echo "TRY_AGAIN";
                                }
                            } else {
                                echo "WRONG_PASSWORD";
                            }
                            break;
                        CASE 926:
                            // Check Balance
                            $phoneNum = html_filter($dbc, $_REQUEST['phoneNum']);
                            if($source == '1'){
                                $phoneNum = "+".html_filter($dbc, $_REQUEST['phoneNum']);
                            }
                            $customerData = get_customer_by_phoneNum($dbc, $phoneNum);
                            if (check_if_number_exist($dbc, $phoneNum)) {

                                $acc_info = get_cus_account_info_by_customerID($dbc, $customerData['id']);
                                echo $acc_info['balance'];
                            } else {
                                echo "PHONE_DONT_EXIST";
                            }
                            break;
                        CASE 927:
                            // Generate Unregistered user token
                            $sendPhoneNum = html_filter($dbc, $_REQUEST['senderPhone']);
                            if($source == '1'){
                                $sendPhoneNum = "+".html_filter($dbc, $_REQUEST['senderPhone']);
                            }
                            $amount = html_filter($dbc, $_REQUEST['amount']);
                            $keyCode = html_filter($dbc, $_REQUEST['keyCode']);
                            $tokenPin = html_filter($dbc, $_REQUEST['pin']);
                            $recipientCountry = html_filter($dbc, $_REQUEST['recipientCountry']);


                            if (check_phoneNum_and_keyCode($dbc, $sendPhoneNum, $keyCode)) {
                                $senderData = get_customer_by_phoneNum($dbc, $sendPhoneNum);
                                $recipientData = array();
                                $general_service = "TOKEN";
                                $recipientData['uGroup'] = 1;
                                $recipientData['accountType'] = 2;
                                $recipientData['countryCode'] = $recipientCountry;


                                if (check_if_number_exist_as_superAgent_or_agent_or_individual($dbc, $sendPhoneNum)) {
                                    $check_balance = check_for_enough_balance_token($dbc, $senderData, $recipientData, $amount, $general_service);
                                    if ($check_balance['status'] == true) {
                                        $recipientData['recipientCountryCode'] = $recipientCountry;
                                        $recipientData['recipientAmount'] = "";
                                        $token = generate_token();
                                        $funds = $check_balance['newAmount'];
                                        if (redraw_funds($dbc, $senderData['id'], $funds)) {
                                            if (add_to_token_mgt_after_processing($dbc, $senderData['id'], $senderData['countryCode'], $token, $tokenPin, $check_balance['transaction_uid'], "", "", "", $recipientCountry)) {

                                                $rate = get_conversion_rate($dbc,$senderData['countryCode'],$recipientCountry);
                                                $convertedAmount = $amount * $rate;
                                                $senderAcc = get_cus_account_info_by_customerID($dbc,$senderData['id']);
                                                if (add_main_transaction($dbc, $recipientData, $senderData, $general_service, "", $check_balance['transaction_uid'], "WAITING", $check_balance['fee'], $amount, $convertedAmount, "SMART", $check_balance['pricing_id'])) {

                                                    if(transcription($dbc,$senderData,$recipientData,$general_service,$amount,'',$check_balance['transaction_uid'])) {
                                                        if(update_main_transaction_after_processing($dbc,$check_balance['transaction_uid'],'WAITING',$senderAcc['balance'],0)) {
                                                            $agentFee = $check_balance['fee'] * $check_balance['senderCommission'];
                                                            $payGlobalFee = $check_balance['fee'] * $check_balance['sysCommission'];
                                                            $data = array();
                                                            $data['recipientID'] = $senderData['id'];
                                                            $data['senderID'] = $senderData['id'];
                                                            $data['senderCountryCode'] = $senderData['countryCode'];
                                                            $data['transactionTypes'] = $general_service;
                                                            $data['transaction_uid'] = $check_balance['transaction_uid'];
                                                            if ($senderData['accountType'] == 1) {
                                                                if (add_payGlobal_commission($dbc, $data, $payGlobalFee)) {
                                                                    $message = "Transaction Completed, Token is {$token} and Code is {$tokenPin} for an amount of {$amount}.";
                                                                    sendSMS($sendPhoneNum, $message);
                                                                    echo "(SUCCESSFUL/{$token})";
                                                                }
                                                            } else {
                                                                if (add_agent_commission($dbc, $data, $agentFee, $senderData['countryCode'])) {
                                                                    if (add_payGlobal_commission($dbc, $data, $payGlobalFee)) {
                                                                        $message = "Transaction Completed, Token is {$token} and Code is {$tokenPin} for an amount of {$amount}.";
                                                                        sendSMS($sendPhoneNum, $message);
                                                                        echo "(SUCCESSFUL/{$token})";
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }

                                                } else {
                                                    echo "UNSUCCESSFUL";
                                                }
                                            } else {
                                                echo "UNSUCCESSFUL1";
                                            }
                                        } else {
                                            echo "UNSUCCESSFUL2";
                                        }
                                    } else {
                                        echo "0"; //Insufficient Account Balance Returns 0 string
                                    }
                                } else {
                                    echo("UNAUTHORISED_USER");
                                }
                            } else {
                                echo("Sorry, Error authenticating user!");
                            }
                            break;
                        CASE 928:

                            $from = html_filter($dbc, $_REQUEST['from']);
                            $to = html_filter($dbc, $_REQUEST['to']);
                            $phoneNum = html_filter($dbc, $_REQUEST['phoneNum']);
                            if($source == '1'){
                                $phoneNum = "+".html_filter($dbc, $_REQUEST['phoneNum']);
                            }
                            if (check_if_number_exist($dbc, $phoneNum)) {
                                $customerData = get_customer_by_phoneNum($dbc, $phoneNum);
                                $data = get_mainTransaction_by_dateRange($dbc, $customerData['id'], $from, $to);
                                $res = array();
                                array_push($res['result'], $data);
                                echo json_encode($res);

                            } else {
                                echo "PHONE_DONT_EXIST";
                            }
                            break;

                        CASE 929:
                            $from = html_filter($dbc, $_REQUEST['from']);
                            $to = html_filter($dbc, $_REQUEST['to']);
                            $phoneNum = html_filter($dbc, $_REQUEST['phoneNum']);
                            if($source == '1'){
                                $phoneNum = "+".html_filter($dbc, $_REQUEST['phoneNum']);
                            }
                            if (check_if_number_exist($dbc, $phoneNum)) {
                                //$from = '2017-08-02';
                                // $to = '2017-10-02';
                                $customerData = get_customer_by_phoneNum($dbc, $phoneNum);
                                $datas = get_mainTransaction_by_dateRange_for_recipient($dbc, $customerData['id'], $from, $to);

                                $output = array();
                                foreach ($datas as $data) {
                                    $recipient = get_customer_by_id($dbc, $data['senderID']);
                                    $output[] = array('rcontact' => $recipient['phoneNum'], 'amount' => $data['recipientAmount'], 'date' => $data['dateTime']);
                                }

                                echo json_encode($output);

                            } else {
                                echo "PHONE_DONT_EXIST";
                            }
                            break;

                        CASE 930 :
                            // Change password
                            $phoneNum = html_filter($dbc, $_REQUEST['phoneNum']);
                            if($source == '1'){
                                $phoneNum = "+".html_filter($dbc, $_REQUEST['phoneNum']);
                            }
                            $password = passwordHash($_REQUEST['password'], $mySalt);
                            $keyCode = html_filter($dbc, $_REQUEST['keyCode']);

                            if (check_phoneNum_and_keyCode($dbc, $phoneNum, $keyCode)) {
                                $customerData = get_customer_by_phoneNum($dbc, $phoneNum);
                                if (change_customer_password($dbc, $customerData['id'], $password)) {
                                    echo "SUCCESSFUL";
                                }
                            } else {
                                echo("UNSUCCESSFUL");
                            }
                            break;

                        CASE 931 :
                            // Change USSD PIN
                            $phoneNum = html_filter($dbc, $_REQUEST['phoneNum']);
                            if($source == '1'){
                                $phoneNum = "+".html_filter($dbc, $_REQUEST['phoneNum']);
                            }
                            $pin = html_filter($dbc, $_REQUEST['pin']);
                            $keyCode = html_filter($dbc, $_REQUEST['keyCode']);

                            if (check_phoneNum_and_keyCode($dbc, $phoneNum, $keyCode)) {
                                $customerData = get_customer_by_phoneNum($dbc, $phoneNum);
                                if (change_customer_ussd_pin($dbc, $customerData['id'], $pin)) {
                                    echo "SUCCESSFUL";
                                }
                            } else {
                                echo("UNSUCCESSFUL");
                            }
                            break;
                        CASE 934:
                            // Update Profile
                            $phoneNum = html_filter($dbc, $_REQUEST['phoneNum']);
                            if($source == '1'){
                                $phoneNum = "+".html_filter($dbc, $_REQUEST['phoneNum']);
                            }
                            $fullName = html_filter($dbc, $_REQUEST['fullName']);
                            $idNumber = html_filter($dbc, $_REQUEST['idNumber']);
                            $idType = html_filter($dbc, $_REQUEST['idType']);
                            $idExpiringDate = html_filter($dbc, $_REQUEST['idExpiringDate']);
                            $email = html_filter($dbc, $_REQUEST['email']);
                            $address = html_filter($dbc, $_REQUEST['address']);
                            $city = html_filter($dbc, $_REQUEST['city']);
                            $region = html_filter($dbc, $_REQUEST['region']);
                            $postCode = html_filter($dbc, $_REQUEST['postcode']);
                            $nextOfKin = html_filter($dbc, $_REQUEST['nextOfKin']);
                            $nextOfKin_phone = html_filter($dbc, $_REQUEST['nextOfKin_phone']);
                            $keyCode = html_filter($dbc, $_REQUEST['keyCode']);
                            if (check_phoneNum_and_keyCode($dbc, $phoneNum, $keyCode)) {
                                if (update_customer_smart($dbc, $phoneNum, $fullName, $idType, $idNumber, $address, $email,$idExpiringDate,$city,$region,$postCode,$nextOfKin,$nextOfKin_phone)) {
                                    echo "SUCCESSFUL";
                                } else {
                                    echo "UNSUCCESSFUL";
                                }
                            } else {
                                echo("UNSUCCESSFUL");
                            }

                            break;
                        CASE 935:
                            // View Bank Account Balance
                            $phoneNum = html_filter($dbc, $_REQUEST['phoneNum']);
                            if($source == '1'){
                                $phoneNum = "+".html_filter($dbc, $_REQUEST['phoneNum']);
                            }
                            $keyCode = html_filter($dbc, $_REQUEST['keyCode']);
                            $accountNum = html_filter($dbc, $_REQUEST['accountNumber']);
                            $customerData = get_customer_by_phoneNum($dbc, $phoneNum);

                            if (check_phoneNum_and_keyCode($dbc, $phoneNum, $keyCode)) {
                                $linked = bank_get_linked_accounts($phoneNum);
                                if ($linked['status'] != 'NOT_LINKED') {
                                    $linkedArray = array($linked['account1'], $linked['account2'], $linked['account3']);
                                    if (in_array($accountNum, $linkedArray)) {
                                        $balance = bank_balance_request($accountNum);
                                        if ($balance['comment'] == 'Successful') {
                                            echo $balance['availableBal'];
                                        } else {
                                            echo "ERROR_OCCUR";
                                        }
                                    } else {
                                        echo "INVALID_ACCOUNT_NUMBER";
                                    }
                                } else {
                                    echo "NOT_LINKED";
                                }
                            } else {
                                echo("Sorry, Error authenticating user!");
                            }

                            break;
                        /*
                         * New set of transactions starting from code 400
                         */
                        CASE 401: // Money  transfer
                            //Send money to another pay global Account both local and International
                            if (isset($_REQUEST['status'])) {
                                $response = array();
                                $status = html_filter($dbc, $_REQUEST['status']);
                                if ($status == true) {
                                    $fee = html_filter($dbc, $_REQUEST['fee']);
                                    $transaction_uid = html_filter($dbc, $_REQUEST['transaction_uid']);

                                    $transactionData = get_main_transaction_by_transaction_uid($dbc, $transaction_uid);
                                    $recipientData = get_customer_by_id($dbc, $transactionData['recipientID']);
                                    $senderData = get_customer_by_id($dbc, $transactionData['senderID']);
                                    $totalAmount = $transactionData['sendersAmount'] + $transactionData['fee'];
                                    if (check_existing_balance($dbc, $transactionData['senderID'], $totalAmount)) {
                                        if ($transactionData['senderCountryCode'] == $transactionData['recipientCountryCode']) {
                                            if (translation($dbc, $transactionData)) {
                                                $senderAcc = get_cus_account_info_by_customerID($dbc, $senderData['id']);
                                                $recipientAcc = get_cus_account_info_by_customerID($dbc, $recipientData['id']);
                                                if (update_main_transaction_after_processing($dbc, $transactionData['transaction_uid'], "COMPLETED", $senderAcc['balance'], $recipientAcc['balance'])) {
                                                    $pricing = get_pricing_by_id($dbc, $transactionData['pricing_id']);
                                                    /*
                                                     * This set of code apply when an agent of super agent is loading an individual Wallet.
                                                     * Thus the agent or the super agent received 0.004% of the amount
                                                     */
                                                    if (($senderData['accountType'] == 2 OR $senderData['accountType'] == 4) AND $recipientData['accountType'] == 1) {

                                                        $senderCom = $fee * $pricing['senderCommission'];
                                                        if (add_agent_commission_for_addMoney($dbc, $transactionData, $senderCom, $senderData['countryCode'], $senderData['id'])) {
                                                            // Redraw funds
                                                            add_commissionExpense($dbc, $senderData['countryCode'], $senderCom);
                                                        }
                                                    }

                                                    if ($senderData['accountType'] == 4 AND $recipientData['accountType'] == 2) {
                                                        $senderCom = $fee * $pricing['senderCommission'];
                                                        if (add_agent_commission_for_addMoney($dbc, $transactionData, $senderCom, $senderData['countryCode'], $senderData['id'])) {
                                                            // Redraw funds
                                                            add_commissionExpense($dbc, $senderData['countryCode'], $senderCom);
                                                        }
                                                    }
                                                    /*
                                                     *end of loading money commission
                                                     */

                                                    if ($recipientData['accountType'] == 2 OR $recipientData['accountType'] == 4) {// check if recipient is  Agent, then share commission

                                                        $agentFee = $transactionData['fee'] * $pricing['recipientCommission'];
                                                        $payGlobalFee = $transactionData['fee'] * $pricing['sysCommission'];


                                                        if (add_agent_commission($dbc, $transactionData, $agentFee, $recipientData['countryCode'])) {
                                                            if (add_payGlobal_commission($dbc, $transactionData, $payGlobalFee)) {


                                                                $recipientMessage = "You have received an amount of {$transactionData['recipientAmount']} from {$senderData['fullName']} {$senderData['companyName']}, Transaction ID {$transaction_uid}";
                                                                $senderMessage = "You have Sent an amount of {$transactionData['sendersAmount']} to {$recipientData['fullName']}{$senderData['companyName']}, Transaction ID {$transaction_uid}";

                                                                sendSMS($recipientData['phoneNum'], $recipientMessage);
                                                                if ($senderData['firebaseKey'] != '') {
                                                                    firebaseCall($senderData['firebaseKey'], $senderMessage);
                                                                }
                                                                if ($recipientData['firebaseKey'] != '') {
                                                                    firebaseCall($recipientData['firebaseKey'], $recipientMessage);
                                                                }

                                                                $response['statusCode'] = 200;
                                                                $response['message'] = "Transaction Successful";
                                                            }
                                                        }
                                                    } else { // PayGlobal Takes all fees
                                                        $agentFee = $fee * $pricing['sysCommission'];
                                                        if (add_payGlobal_commission($dbc, $transactionData, $agentFee)) {
                                                            $message = "You have received an amount of {$transactionData['recipientAmount']} from {$senderData['fullName']}, Transaction ID {$transaction_uid}";
                                                            sendSMS($recipientData['phoneNum'], $message);
                                                            $response['statusCode'] = 200;
                                                            $response['message'] = "Transaction Successful";
                                                        }
                                                    }
                                                }
                                            } else {
                                                $response['statusCode'] = 500;
                                                $response['message'] = "Error Occur!";
                                            }
                                        } else {
                                            /*
                                             * INTERNATIONAL MONEY TRANSFER
                                             */
                                            if(redraw_funds($dbc,$senderData['id'],$transactionData['sendersAmount'])) {
                                                if (add_funds($dbc, $recipientData['id'], $transactionData['recipientAmount'])){
                                                    if (transcription($dbc, $senderData, $recipientData, $transactionData['transactionTypes'], $transactionData['sendersAmount'], $transactionData['billCode'], $transaction_uid)) {
                                                        //redraw fee
                                                        if (redraw_funds($dbc, $senderData['id'], $transactionData['fee'])) {
                                                            $senderAcc = get_cus_account_info_by_customerID($dbc, $senderData['id']);
                                                            $recipientAcc = get_cus_account_info_by_customerID($dbc, $recipientData['id']);
                                                            if (update_main_transaction_after_processing($dbc, $transactionData['transaction_uid'], "COMPLETED", $senderAcc['balance'], $recipientAcc['balance'])) {
                                                                $newTransactionData = get_main_transaction_by_transaction_uid($dbc, $transaction_uid);
                                                                $pricing = get_pricing_by_id($dbc, $transactionData['pricing_id']);
                                                                if ($recipientData['accountType'] == 2 OR $recipientData['accountType'] == 4) {// check if recipient is  Agent, then share commission


                                                                    $agentFee = $transactionData['fee'] * $pricing['recipientCommission'];
                                                                    $payGlobalFee = $transactionData['fee'] * $pricing['sysCommission'];


                                                                    if (add_agent_commission($dbc, $newTransactionData, $agentFee, $recipientData['countryCode'])) {
                                                                        if (add_payGlobal_commission($dbc, $newTransactionData, $payGlobalFee)) {

                                                                            if ($senderData['companyName'] == '') {
                                                                                $senderData['companyName'] = $senderData['fullName'];
                                                                            }

                                                                            if ($recipientData['companyName'] == '') {
                                                                                $recipientData['companyName'] = $recipientData['fullName'];
                                                                            }


                                                                            $recipientMessage = "You have received an amount of {$newTransactionData['recipientAmount']} from {$senderData['companyName']}, Transaction ID {$transaction_uid}";
                                                                            $senderMessage = "You have Sent an amount of {$newTransactionData['senderAmount']} to {$recipientData['companyName']}, Transaction ID {$transaction_uid}";

                                                                            sendSMS($senderData['phoneNum'], $senderMessage);
                                                                            if ($senderData['firebaseKey'] != '') {
                                                                                firebaseCall($senderData['firebaseKey'], $senderMessage);
                                                                            }
                                                                            if ($recipientData['firebaseKey'] != '') {
                                                                                firebaseCall($recipientData['firebaseKey'], $recipientMessage);
                                                                            }


                                                                            sendSMS($recipientData['phoneNum'], $recipientMessage);
                                                                            $response['statusCode'] = 200;
                                                                            $response['message'] = "Transaction Successful";
                                                                        }
                                                                    }
                                                                } else {
                                                                    // PayGlobal takes all fees
                                                                    $payGlobalFee = $transactionData['fee'] * $pricing['sysCommission'];
                                                                    if (add_payGlobal_commission($dbc, $transactionData, $payGlobalFee)) {
                                                                        $recipientMessage = "You have received an amount of {$newTransactionData['recipientAmount']} from {$senderData['fullName']}, Transaction ID {$transaction_uid}";
                                                                        $senderMessage = "You have Sent an amount of {$newTransactionData['senderAmount']} to {$recipientData['fullName']}, Transaction ID {$transaction_uid}";

                                                                        sendSMS($recipientData['phoneNum'], $recipientMessage);
                                                                        if ($senderData['firebaseKey'] != '') {
                                                                            firebaseCall($senderData['firebaseKey'], $senderMessage);
                                                                        }
                                                                        if ($recipientData['firebaseKey'] != '') {
                                                                            firebaseCall($recipientData['firebaseKey'], $recipientMessage);
                                                                        }

                                                                        sendSMS($recipientData['phoneNum'], $recipientMessage);
                                                                        sendSMS($senderData['phoneNum'], $senderMessage);
                                                                        $response['statusCode'] = 200;
                                                                        $response['message'] = "Transaction Successful";
                                                                    }

                                                                }
                                                            } else {
                                                                $response['statusCode'] = 500;
                                                                $response['message'] = "Error occur";
                                                            }

                                                        }
                                                    }
                                                }
                                            }
                                        }


                                    } else {
                                        echo "LOW_BALANCE";
                                    }

                                } else {
                                    $response['statusCode'] = 500;
                                    $response['message'] = 'Error status code';
                                }

                                echo json_encode($response);
                            } else {
                                // Main money transfer Initiation.
                                $response = array();
                                $sendPhoneNum = html_filter($dbc, $_REQUEST['senderPhone']);
                                if($source == '1'){
                                    $sendPhoneNum = "+".html_filter($dbc, $_REQUEST['senderPhone']);
                                }
                                $recipientPhoneNum = html_filter($dbc, $_REQUEST['recipientPhone']);
                                if($source == '1'){
                                    $recipientPhoneNum = "+".html_filter($dbc, $_REQUEST['recipientPhone']);
                                }
                                $transactionType = html_filter($dbc, $_REQUEST['transactionType']);
                                $amount = html_filter($dbc, $_REQUEST['amount']);
                                $keyCode = html_filter($dbc, $_REQUEST['keyCode']);

                                if (check_phoneNum_and_keyCode($dbc, $sendPhoneNum, $keyCode)) {
                                    if (check_if_number_exist($dbc, $recipientPhoneNum)) {
                                        if (check_if_number_exist_as_superAgent_or_agent_or_individual($dbc, $sendPhoneNum)) {
                                            if (check_if_number_exist_as_superAgent_or_agent_or_individual_or_merchant($dbc, $recipientPhoneNum)) {
                                                $sendersData = get_customer_by_phoneNum($dbc, $sendPhoneNum);
                                                $recipientData = get_customer_by_phoneNum($dbc, $recipientPhoneNum);
                                                $check_balance = check_if_balance_is_greater_than_redraw($dbc, $sendersData, $amount, $recipientData, $transactionType);
                                                if ($check_balance['status'] == true) {
                                                    if (dailyKyc($dbc, $sendersData['id'], $sendersData['countryCode'], $check_balance['exactAmount'], $check_balance['fee'])) {
                                                        if (monthlyKyc($dbc, $sendersData['id'], $sendersData['countryCode'], $check_balance['exactAmount'], $check_balance['fee'])) {

                                                            //get converted rate
                                                            $rate = get_conversion_rate($dbc,$sendersData['countryCode'],$recipientData['countryCode']);
                                                            $recipientAmount = $check_balance['exactAmount'] * $rate;

                                                            if (add_main_transaction($dbc, $recipientData, $sendersData, $transactionType, "", $check_balance['transaction_uid'], "PROCESSING", $check_balance['fee'], $check_balance['exactAmount'], $recipientAmount, "SMART", $check_balance['pricing_id'])) {

                                                                $response['statusCode'] = 200;
                                                                $response['recipientName'] = $check_balance['recipientName'];
                                                                $response['fee'] = $check_balance['fee'];
                                                                $response['transaction_uid'] = $check_balance['transaction_uid'];
                                                                $response['senderAmount'] = $check_balance['exactAmount'];
                                                                $response['recipientAmount'] = $recipientAmount;
                                                                $response['status'] = $check_balance['status'];
                                                                // echo "({$check_balance['recipientName']}/{$check_balance['fee']}*{$check_balance['transaction_uid']}!{$check_balance['status']})";
                                                            }
                                                        } else {
                                                            // Monthly Limit
                                                            $response['statusCode'] = 500;
                                                            $response['message'] = 'Monthly Limit Reached';
                                                        }
                                                    } else {
                                                        // Daily Limit
                                                        $response['statusCode'] = 500;
                                                        $response['message'] = 'Daily Limit Reached';
                                                    }
                                                } else {
                                                    //Insufficient Account Balance Returns
                                                    $response['statusCode'] = 500;
                                                    $response['message'] = 'You have Insufficient Account Balance';
                                                }
                                            } else {
                                                //Invalid Recipient Number
                                                $response['statusCode'] = 500;
                                                $response['message'] = 'Invalid Recipient Number';
                                            }
                                        } else {
                                            echo 'Unauthorised to perform this transaction';
                                        }

                                    } else {
                                        //Recipient Number DO not exist
                                        $response['statusCode'] = 500;
                                        $response['message'] = 'Sorry, Recipient does not Exist, Please use Token!';
                                    }
                                } else {
                                    //Recipient Number DO not exist
                                    $response['statusCode'] = 500;
                                    $response['message'] = 'Sorry, Error authenticating user!';
                                }
                                echo json_encode($response);
                            }
                            break;

                        CASE 402: // Money  Payment to marchant
                            //Make payment to a merchant locally
                            if (isset($_REQUEST['status'])) {
                                $response = array();
                                $status = html_filter($dbc, $_REQUEST['status']);
                                if ($status == true) {
                                    $fee = html_filter($dbc, $_REQUEST['fee']);
                                    $transaction_uid = html_filter($dbc, $_REQUEST['transaction_uid']);

                                    $transactionData = get_main_transaction_by_transaction_uid($dbc, $transaction_uid);
                                    $recipientData = get_customer_by_id($dbc, $transactionData['recipientID']);
                                    $senderData = get_customer_by_id($dbc, $transactionData['senderID']);
                                    $totalAmount = $transactionData['sendersAmount'] + $transactionData['fee'];
                                    if (check_existing_balance($dbc, $transactionData['senderID'], $totalAmount)) {
                                        if ($transactionData['senderCountryCode'] == $transactionData['recipientCountryCode']) {
                                            if (translation($dbc, $transactionData)) {
                                                $senderAcc = get_cus_account_info_by_customerID($dbc, $senderData['id']);
                                                $recipientAcc = get_cus_account_info_by_customerID($dbc, $recipientData['id']);
                                                if (update_main_transaction_after_processing($dbc, $transactionData['transaction_uid'], "COMPLETED", $senderAcc['balance'], $recipientAcc['balance'])) {
                                                    $pricing = get_pricing_by_id($dbc, $transactionData['pricing_id']);

                                                    //PayGlobal Takes all fees
                                                    $agentFee = $fee * $pricing['sysCommission'];
                                                    if (add_payGlobal_commission($dbc, $transactionData, $agentFee)) {
                                                        $recipientMessage = "You have received an amount of {$transactionData['recipientAmount']} from {$senderData['fullName']}, Transaction ID {$transaction_uid}";
                                                        sendSMS($recipientData['phoneNum'], $recipientMessage);
                                                        if ($recipientData['firebaseKey'] != '') {
                                                            firebaseCall($recipientData['firebaseKey'], $recipientMessage);
                                                        }


                                                        $senderMessage = "You Made a amount of {$transactionData['senderAmount']} To {$recipientData['fullName']}, Transaction ID {$transaction_uid}";
                                                        sendSMS($senderData['phoneNum'], $senderMessage);
                                                        if ($senderData['firebaseKey'] != '') {
                                                            firebaseCall($senderData['firebaseKey'], $senderMessage);
                                                        }

                                                        $response['statusCode'] = 200;
                                                        $response['message'] = "Transaction Successful";
                                                    }
                                                }
                                            } else {
                                                $response['statusCode'] = 500;
                                                $response['message'] = "Error Occur!";
                                            }
                                        } else {
                                            $response['statusCode'] = 500;
                                            $response['message'] = "Make payment is restricted to same country";
                                        }

                                    } else {
                                        $response['statusCode'] = 500;
                                        $response['message'] = "You don't have enough balance, Please load your wallet";
                                    }

                                } else {
                                    $response['statusCode'] = 500;
                                    $response['message'] = 'Error status code';
                                }

                                echo json_encode($response);
                            } else {
                                // Main Make Payment Initiation.
                                $response = array();
                                $response['statusCode'] = 500;
                                $response['message'] = "Service Temporary unavailable ";
                                echo json_encode($response);
                            }
                            break;

                        CASE 403: //Bill Payment
                            if (isset($_REQUEST['status'])) {
                                $response = array();
                                $status = html_filter($dbc, $_REQUEST['status']);
                                if ($status == true) {
                                    $fee = html_filter($dbc, $_REQUEST['fee']);
                                    $transaction_uid = html_filter($dbc, $_REQUEST['transaction_uid']);

                                    $transactionData = get_main_transaction_by_transaction_uid($dbc, $transaction_uid);
                                    $recipientData = get_customer_by_id($dbc, $transactionData['recipientID']);
                                    $senderData = get_customer_by_id($dbc, $transactionData['senderID']);
                                    $totalAmount = $transactionData['sendersAmount'] + $transactionData['fee'];
                                    if (check_existing_balance($dbc, $transactionData['senderID'], $totalAmount)) {
                                        if ($transactionData['senderCountryCode'] == $transactionData['recipientCountryCode']) {
                                            if (translation($dbc, $transactionData)) {
                                                $senderAcc = get_cus_account_info_by_customerID($dbc, $senderData['id']);
                                                $recipientAcc = get_cus_account_info_by_customerID($dbc, $recipientData['id']);
                                                if (update_main_transaction_after_processing($dbc, $transactionData['transaction_uid'], "COMPLETED", $senderAcc['balance'], $recipientAcc['balance'])) {
                                                    $pricing = get_pricing_by_id($dbc, $transactionData['pricing_id']);

                                                    //PayGlobal Takes all fees
                                                    $agentFee = $fee * $pricing['sysCommission'];
                                                    if (add_payGlobal_commission($dbc, $transactionData, $agentFee)) {
                                                        $recipientMessage = "You have received an amount of {$transactionData['recipientAmount']} from {$senderData['fullName']}, Transaction ID {$transaction_uid}";
                                                        sendSMS($recipientData['phoneNum'], $recipientMessage);
                                                        if ($recipientData['firebaseKey'] != '') {
                                                            firebaseCall($recipientData['firebaseKey'], $recipientMessage);
                                                        }


                                                        $senderMessage = "You Made a amount of {$transactionData['senderAmount']} To {$recipientData['fullName']}, Transaction ID {$transaction_uid}";
                                                        sendSMS($senderData['phoneNum'], $senderMessage);
                                                        if ($senderData['firebaseKey'] != '') {
                                                            firebaseCall($senderData['firebaseKey'], $senderMessage);
                                                        }

                                                        $response['statusCode'] = 200;
                                                        $response['message'] = "Transaction Successful";
                                                    }
                                                }
                                            } else {
                                                $response['statusCode'] = 500;
                                                $response['message'] = "Error Occur!";
                                            }
                                        } else {

                                            // International Bill or Premium Payment
                                            if (redraw_funds($dbc,$senderData['id'],$totalAmount)) {
                                                if(add_funds($dbc,$recipientData['id'],$transactionData['recipientAmount'])) {
                                                    if(transcription($dbc,$senderData,$recipientData,$transactionData['transactionTypes'],$transactionData['sendersAmount'],$transactionData['billCode'],$transactionData['transaction_uid'])) {
                                                        $senderAcc = get_cus_account_info_by_customerID($dbc, $senderData['id']);
                                                        $recipientAcc = get_cus_account_info_by_customerID($dbc, $recipientData['id']);
                                                        if (update_main_transaction_after_processing($dbc, $transactionData['transaction_uid'], "COMPLETED", $senderAcc['balance'], $recipientAcc['balance'])) {
                                                            $pricing = get_pricing_by_id($dbc, $transactionData['pricing_id']);

                                                            //PayGlobal Takes all fees
                                                            $agentFee = $fee * $pricing['sysCommission'];
                                                            if (add_payGlobal_commission($dbc, $transactionData, $agentFee)) {
                                                                $recipientMessage = "You have received an amount of {$transactionData['recipientAmount']} from {$senderData['fullName']}, Transaction ID {$transaction_uid}";
                                                                sendSMS($recipientData['phoneNum'], $recipientMessage);
                                                                if ($recipientData['firebaseKey'] != '') {
                                                                    firebaseCall($recipientData['firebaseKey'], $recipientMessage);
                                                                }


                                                                $senderMessage = "You Made a amount of {$transactionData['senderAmount']} To {$recipientData['fullName']}, Transaction ID {$transaction_uid}";
                                                                sendSMS($senderData['phoneNum'], $senderMessage);
                                                                if ($senderData['firebaseKey'] != '') {
                                                                    firebaseCall($senderData['firebaseKey'], $senderMessage);
                                                                }

                                                                $response['statusCode'] = 200;
                                                                $response['message'] = "Transaction Successful";
                                                            }
                                                        }
                                                    }
                                                }
                                            } else {
                                                $response['statusCode'] = 500;
                                                $response['message'] = "Error Occur!";
                                            }
                                        }

                                    } else {
                                        $response['statusCode'] = 500;
                                        $response['message'] = "You don't have enough balance, Please load your wallet";
                                    }

                                } else {
                                    $response['statusCode'] = 500;
                                    $response['message'] = 'Error status code';
                                }

                                echo json_encode($response);
                            } else {
                                // Bill Payment with bill code
                                $response = array();

                                $sendPhoneNum = html_filter($dbc, $_REQUEST['senderPhone']);
                                if($source == '1'){
                                    $sendPhoneNum = "+".html_filter($dbc, $_REQUEST['senderPhone']);
                                }
                                $keyCode = html_filter($dbc, $_REQUEST['keyCode']);
                                $recipientPhoneNum = html_filter($dbc, $_REQUEST['recipientPhone']);
                                if($source == '1'){
                                    $recipientPhoneNum = "+".html_filter($dbc, $_REQUEST['recipientPhone']);
                                }
                                $amount = html_filter($dbc, $_REQUEST['amount']);
                                $billCode = html_filter($dbc, $_REQUEST['billCode']);
                                $transactionType = html_filter($dbc, $_REQUEST['transactionType']);

                                if (check_phoneNum_and_keyCode($dbc, $sendPhoneNum, $keyCode)) {
                                    if (check_if_number_exist_as_superAgent_or_agent_or_individual($dbc, $sendPhoneNum)) {
                                        if (check_if_number_exist_as_merchant($dbc, $recipientPhoneNum)) {
                                            $sendersData = get_customer_by_phoneNum($dbc, $sendPhoneNum);
                                            $recipientData = get_customer_by_phoneNum($dbc, $recipientPhoneNum);
                                            $check_balance = check_if_balance_is_greater_than_redraw($dbc, $sendersData, $amount, $recipientData, $transactionType);

                                            $rate = get_conversion_rate($dbc,$sendersData['countryCode'],$recipientData['countryCode']);
                                            $convertedAmount = $amount * $rate;

                                            if ($check_balance['status'] == true) {
                                                if (dailyKyc($dbc, $sendersData['id'], $sendersData['countryCode'], $check_balance['exactAmount'], $check_balance['fee'])) {
                                                    if (monthlyKyc($dbc, $sendersData['id'], $sendersData['countryCode'], $check_balance['exactAmount'], $check_balance['fee'])) {
                                                        if (add_main_transaction($dbc, $recipientData, $sendersData, $transactionType, $billCode, $check_balance['transaction_uid'], "WAITING", $check_balance['fee'], $check_balance['exactAmount'], $convertedAmount, "SMART",$check_balance['pricing_id'])) {

                                                            //echo "({$check_balance['recipientName']}/{$check_balance['fee']}*{$check_balance['transaction_uid']}!{$check_balance['status']})";
                                                            $response['statusCode'] = 200;
                                                            $response['recipientName'] = $check_balance['recipientName'];
                                                            $response['fee'] = $check_balance['fee'];
                                                            $response['transaction_uid'] = $check_balance['transaction_uid'];
                                                            $response['convertedAmount'] = $convertedAmount;
                                                            $response['billCode'] = $billCode;
                                                            $response['status'] = $check_balance['status'];
                                                            $response['recipientCountry'] = $recipientData['countryCode'];
                                                        }
                                                    } else {
                                                        //echo "MONTHLY_LIMIT";
                                                        $response['statusCode'] = 500;
                                                        $response['message'] = 'You have reach your monthly Limit';
                                                    }
                                                } else {
                                                    //echo "DAILY_LIMIT";
                                                    $response['statusCode'] = 500;
                                                    $response['message'] = 'You have reach your Daily Limit';
                                                }
                                            } else {
                                                //echo "0"; //Insufficient Account Balance Returns 0 string
                                                $response['statusCode'] = 500;
                                                $response['message'] = 'Insufficient Wallet Balance, Load Wallet';
                                            }
                                        } else {
                                            //echo("Sorry, transaction is only for merchants and Individuals");
                                            $response['statusCode'] = 500;
                                            $response['message'] = 'Sorry, transaction is only for merchants';
                                        }
                                    } else {
                                        //echo 'Sorry you not authorise for this transactions';
                                        $response['statusCode'] = 500;
                                        $response['message'] = 'Sorry you not authorise for this transactions';
                                    }
                                } else {
                                    // Sorry, Error authenticating user!
                                    $response['statusCode'] = 500;
                                    $response['message'] = 'Sorry, Error authenticating user!';
                                }
                                echo json_encode($response);
                            }
                            break;

                        CASE 404: //roaming Payment
                            $status = html_filter($dbc, $_REQUEST['status']);
                            if ($status == true) {
                                $response = array();
                                $transaction_uid = html_filter($dbc, $_REQUEST['transaction_uid']);
                                $convertedFee = html_filter($dbc, $_REQUEST['convertedFee']);

                                $transactionData = get_main_transaction_by_transaction_uid($dbc, $transaction_uid);
                                $senderData = get_customer_by_id($dbc, $transactionData['senderID']);
                                $recipientData = get_customer_by_id($dbc, $transactionData['recipientID']);
                                if (transcription($dbc, $senderData, $recipientData, $transactionData['transactionTypes'], $transactionData['sendersAmount'], $transactionData['billCode'], $transaction_uid)) {

                                    if (redraw_funds($dbc, $senderData['id'], $convertedFee)) {
                                        $senderAcc = get_cus_account_info_by_customerID($dbc, $senderData['id']);
                                        $recipientAcc = get_cus_account_info_by_customerID($dbc, $recipientData['id']);

                                        if (update_main_transaction_after_processing($dbc, $transactionData['transaction_uid'], "COMPLETED", $senderAcc['balance'], $recipientAcc['balance'])) {
                                            $newTransactionData = get_main_transaction_by_transaction_uid($dbc, $transaction_uid);

                                            if (add_payGlobal_commission($dbc, $newTransactionData, $convertedFee)) {
                                                $recipientMessage = "You have received an amount of {$newTransactionData['recipientAmount']} from {$senderData['fullName']}, Transaction ID {$transaction_uid}";
                                                $senderMessage = "Payment was made with an amount of {$newTransactionData['senderAmount']} to {$recipientData['CompanyName']}, Transaction ID {$transaction_uid}";
                                                sendSMS($recipientData['phoneNum'], $recipientMessage);
                                                if ($senderData['firebaseKey'] != '') {
                                                    firebaseCall($senderData['firebaseKey'], $senderMessage);
                                                }
                                                if ($recipientData['firebaseKey'] != '') {
                                                    firebaseCall($recipientData['firebaseKey'], $recipientMessage);
                                                }

                                                sendSMS($recipientData['phoneNum'], $recipientMessage);
                                                $response['statusCode'] = 200;
                                                $response['message'] = 'Roaming payment successful';
                                            }

                                        } else {
                                            $response['statusCode'] = 500;
                                            $response['message'] = 'Sorry, Occur';
                                        }
                                    }
                                }

                                echo json_encode($response);
                            } else {
                                $response = array();

                                $sendPhoneNum = html_filter($dbc, $_REQUEST['senderPhone']);
                                if($source == '1'){
                                    $sendPhoneNum = "+".html_filter($dbc, $_REQUEST['senderPhone']);
                                }
                                $recipientPhoneNum = html_filter($dbc, $_REQUEST['recipientPhone']);
                                if($source == '1'){
                                    $recipientPhoneNum = "+".html_filter($dbc, $_REQUEST['recipientPhone']);
                                }
                                $transactionType = html_filter($dbc, $_REQUEST['transactionType']);
                                $amount = html_filter($dbc, $_REQUEST['amount']);
                                $keyCode = html_filter($dbc, $_REQUEST['keyCode']);

                                if (check_phoneNum_and_keyCode($dbc, $sendPhoneNum, $keyCode)) {
                                    if (check_if_number_exist($dbc, $recipientPhoneNum)) {
                                        if (check_if_number_exist_as_individual($dbc, $sendPhoneNum)) {
                                            if (check_if_number_exist_as_merchant($dbc, $recipientPhoneNum)) {
                                                $sendersData = get_customer_by_phoneNum($dbc, $sendPhoneNum);
                                                $recipientData = get_customer_by_phoneNum($dbc, $recipientPhoneNum);
                                                $check_balance = check_if_balance_is_greater_than_redraw_roaming($dbc, $sendersData, $amount, $recipientData, $transactionType);
                                                if ($check_balance['status'] == true) {
                                                    if (dailyKyc($dbc, $sendersData['id'], $sendersData['countryCode'], $check_balance['convertedAmount'], $check_balance['fee'])) {
                                                        if (monthlyKyc($dbc, $sendersData['id'], $sendersData['countryCode'], $check_balance['convertedAmount'], $check_balance['fee'])) {
                                                            if (add_main_transaction($dbc, $recipientData, $sendersData, $transactionType, "", $check_balance['transaction_uid'], "PROCESSING", $check_balance['fee'], $check_balance['convertedAmount'], $check_balance['exactAmount'], "SMART", $check_balance['pricing_id'])) {
                                                                //echo "({$check_balance['recipientName']}/{$check_balance['fee']}*{$check_balance['transaction_uid']}!{$check_balance['status']}~{$check_balance['convertedAmount']}|{$check_balance['convertedFee']})";
                                                                $response['statusCode'] = 200;
                                                                $response['recipientName'] = $check_balance['recipientName'];
                                                                $response['fee'] = $check_balance['fee'];
                                                                $response['transaction_uid'] = $check_balance['transaction_uid'];
                                                                $response['status'] = $check_balance['status'];
                                                                $response['convertedAmount'] = $check_balance['convertedAmount'];
                                                                $response['convertedFee'] = $check_balance['convertedFee'];
                                                            }
                                                        } else {
                                                            //echo "MONTHLY_LIMIT";
                                                            $response['statusCode'] = 500;
                                                            $response['message'] = 'You have reach your Monthly Limit';
                                                        }
                                                    } else {
                                                        //echo "DAILY_LIMIT";
                                                        $response['statusCode'] = 500;
                                                        $response['message'] = 'You have reach your Daily Limit';
                                                    }
                                                } else {
                                                    //echo "0"; //Insufficient Account Balance Returns 0 string
                                                    $response['statusCode'] = 500;
                                                    $response['message'] = 'Insufficient Wallet Balance, Load Wallet';
                                                }
                                            } else {
                                                //Invalid Recipient Number
                                                $response['statusCode'] = 500;
                                                $response['message'] = 'Invalid Recipient Number, Please try Again';
                                            }
                                        } else {
                                            //Unauthorised user
                                            $response['statusCode'] = 500;
                                            $response['message'] = 'Unauthorised to perform this transaction';
                                        }

                                    } else {
                                        //Invalid Recipient user
                                        $response['statusCode'] = 500;
                                        $response['message'] = 'Sorry, Recipient does not Exist, Please use Token!';
                                    }
                                } else {
                                    //Unauthorised user
                                    $response['statusCode'] = 500;
                                    $response['message'] = 'Sorry, Error Authentication';
                                }
                                echo json_encode($response);
                            }

                            break;
                        CASE 405: //Activate Debit Card
                            $response = array();
                            $sendPhoneNum = html_filter($dbc, $_REQUEST['senderPhone']);
                            if($source == '1'){
                                $sendPhoneNum = "+".html_filter($dbc, $_REQUEST['senderPhone']);
                            }
                            $keyCode = html_filter($dbc, $_REQUEST['keyCode']);
                            if (check_phoneNum_and_keyCode($dbc, $sendPhoneNum, $keyCode)) {
                                $customerData = get_customer_by_phoneNum($dbc, $sendPhoneNum);
                                if (z_check_customer_already_signUp($dbc, $customerData['id'])) {
                                    $response['statusCode'] = 500;
                                    $response['message'] = 'You have already Activated, Please proceed to add a Card';
                                } else {
                                    //$test = z_signUp($dbc, $customerData, genActive_id());
                                    if (z_signUp($dbc, $customerData, genActive_id())) {
                                        $response['statusCode'] = 200;
                                        $response['message'] = 'Debit Card Option Activated';
                                    } else {
                                        $response['statusCode'] = 500;
                                        $response['message'] = 'Error Activating Debit Card Option';
                                    }

                                }
                            } else {
                                // Sorry, Error authenticating user!
                                $response['statusCode'] = 500;
                                $response['message'] = 'Sorry, Error authenticating user!';
                            }
                            echo json_encode($response);
                            break;
                        CASE 406: //Add New Debit Card

                            $response = array();
                            $sendPhoneNum = html_filter($dbc, $_REQUEST['senderPhone']);
                            if($source == '1'){
                                $sendPhoneNum = "+".html_filter($dbc, $_REQUEST['senderPhone']);
                            }
                            $keyCode = html_filter($dbc, $_REQUEST['keyCode']);

                            $cardType = html_filter($dbc, $_REQUEST['cardType']);
                            $cardNumber = html_filter($dbc, $_REQUEST['cardNumber']);
                            $nameOnCard = html_filter($dbc, $_REQUEST['nameOnCard']);
                            $cardCVV = html_filter($dbc, $_REQUEST['cardCVV']);
                            $cardExMonth = html_filter($dbc, $_REQUEST['cardExMonth']);
                            $cardExYear = html_filter($dbc, $_REQUEST['cardExYear']);
                            $cardStatus = 'good';
                            if($cardStatus == 'good') {
                                if(is_numeric($cardNumber) AND is_numeric($cardCVV)) {
                                    if(strlen($cardNumber) == 16) {
                                        if (check_phoneNum_and_keyCode($dbc, $sendPhoneNum, $keyCode)) {
                                            $customerData = get_customer_by_phoneNum($dbc, $sendPhoneNum);
                                            if (z_check_customer_already_signUp($dbc, $customerData['id'])) {
                                                $res = z_add_new_card($dbc, $customerData, $cardType, $cardNumber, $nameOnCard, $cardCVV, $cardExMonth, $cardExYear);
                                                //$response = $res;
                                                if ($res['status'] == 'true') {
                                                    $response['statusCode'] = 200;
                                                    $response['message'] = $res['message'];
                                                } else {
                                                    $response['statusCode'] = 500;
                                                    $response['message'] = $res['message'];
                                                }
                                            } else {
                                                $response['statusCode'] = 500;
                                                $response['message'] = 'Debit Card Option Not activated';
                                            }
                                        } else {
                                            // Sorry, Error authenticating user!
                                            $response['statusCode'] = 500;
                                            $response['message'] = 'Sorry, Error authenticating user!';
                                        }
                                    }else{
                                        $response['statusCode'] = 500;
                                        $response['message'] = 'Invalid Card Length!';
                                    }
                                }else{
                                    $response['statusCode'] = 500;
                                    $response['message'] = 'Invalid Card number!';
                                }
                            }else{
                                $response['statusCode'] = 500;
                                $response['message'] = 'Sorry, Service not available now.';
                            }
                            echo json_encode($response);
                            break;
                        CASE 407: //Confirm Debit Card
                            $response = array();
                            $sendPhoneNum = html_filter($dbc, $_REQUEST['senderPhone']);
                            if($source == '1'){
                                $sendPhoneNum = "+".html_filter($dbc, $_REQUEST['senderPhone']);
                            }
                            $keyCode = html_filter($dbc, $_REQUEST['keyCode']);

                            $cardID = html_filter($dbc, $_REQUEST['cardID']);
                            $amount = html_filter($dbc, $_REQUEST['amount']);

                            if (check_phoneNum_and_keyCode($dbc, $sendPhoneNum, $keyCode)) {
                                $response['statusCode'] = 500;
                                $response['message'] = 'Please update App Now, for this feature';
                            } else {
                                // Sorry, Error authenticating user!
                                $response['statusCode'] = 500;
                                $response['message'] = 'Sorry, Error authenticating user!';
                            }
                            echo json_encode($response);
                            break;
                        CASE 408: //List All cards
                            $response = array();
                            $sendPhoneNum = html_filter($dbc, $_REQUEST['senderPhone']);
                            if($source == '1'){
                                $sendPhoneNum = "+".html_filter($dbc, $_REQUEST['senderPhone']);
                            }
                            $keyCode = html_filter($dbc, $_REQUEST['keyCode']);
                            if (check_phoneNum_and_keyCode($dbc, $sendPhoneNum, $keyCode)) {
                                $customerData = get_customer_by_phoneNum($dbc, $sendPhoneNum);
                                if (z_check_customer_already_signUp($dbc, $customerData['id'])) {
                                    $cards = z_list_all_cards($dbc, $customerData['id']);
                                    $response = $cards;
                                    $response['statusCode'] = 200;
                                } else {
                                    $response['statusCode'] = 500;
                                    $response['message'] = 'No Payment card added yet';
                                }
                            } else {
                                // Sorry, Error authenticating user!
                                $response['statusCode'] = 500;
                                $response['message'] = 'Sorry, Error authenticating user!';
                            }
                            echo json_encode($response);

                            break;

                        CASE 409: //List  of all cards
                            $response = array();
                            $sendPhoneNum = html_filter($dbc, $_REQUEST['senderPhone']);
                            if($source == '1'){
                                $sendPhoneNum = "+".html_filter($dbc, $_REQUEST['senderPhone']);
                            }
                            $keyCode = html_filter($dbc, $_REQUEST['keyCode']);
                            $cardWaiting_ID = html_filter($dbc, $_REQUEST['waiting_id']);
                            if (check_phoneNum_and_keyCode($dbc, $sendPhoneNum, $keyCode)) {
                                $customerData = get_customer_by_phoneNum($dbc, $sendPhoneNum);
                                if (z_check_customer_already_signUp($dbc, $customerData['id'])) {
                                    $cards = z_list_all_cards($dbc, $customerData['id']);
                                    $response = $cards;
                                    $response['statusCode'] = 200;
                                } else {
                                    $response['statusCode'] = 500;
                                    $response['message'] = 'Debit Card Option Not activated';
                                }
                            } else {
                                // Sorry, Error authenticating user!
                                $response['statusCode'] = 500;
                                $response['message'] = 'Sorry, Error authenticating user!';
                            }
                            echo json_encode($response);
                            break;
                        CASE 410: //Perform Transactions by card
                            $response = array();
                            $sendPhoneNum = html_filter($dbc, $_REQUEST['senderPhone']);
                            if($source == '1'){
                                $sendPhoneNum = "+".html_filter($dbc, $_REQUEST['senderPhone']);
                            }
                            $keyCode = html_filter($dbc, $_REQUEST['keyCode']);
                            $cardID = html_filter($dbc, $_REQUEST['cardID']);
                            $amount = html_filter($dbc, $_REQUEST['amount']);
                            if (check_phoneNum_and_keyCode($dbc, $sendPhoneNum, $keyCode)) {
                                $customerData = get_customer_by_phoneNum($dbc, $sendPhoneNum);
                                if (z_check_customer_already_signUp($dbc, $customerData['id'])) {
                                    if (z_check_if_cardID_exist_on_transaction($dbc, $cardID, $customerData['id'])) {
                                        $global_zenith_acc = "+233771000000";

                                        $convertedAmount = z_convert_amount($dbc, $customerData['countryCode'], $amount);
                                        $transaction_uid = genTransactionID();
                                        if (z_add_transaction($dbc, $customerData, $cardID, $amount, $convertedAmount, $transaction_uid, $global_zenith_acc)) {
                                            // pass converted amount to zenith API
                                            $data = z_new_transaction($dbc, $customerData, $cardID, $convertedAmount, $transaction_uid);
                                            if ($data['PaymentResponse']['PaymentStatus'] == 'APPROVED') {
                                                $global_zenith_data = get_customer_by_phoneNum($dbc, $global_zenith_acc);
                                                if (redraw_funds($dbc, $global_zenith_data['id'], $convertedAmount)) {
                                                    if (add_funds($dbc, $customerData['id'], $amount)) {
                                                        $cus_Acc = get_cus_account_info_by_customerID($dbc, $customerData['id']);
                                                        if (z_update_transaction($dbc, $transaction_uid, $data['PaymentResponse']['Reason'], "COMPLETED", $cus_Acc['balance'])) {
                                                            $response['statusCode'] = 200;
                                                            $response['message'] = $data['PaymentResponse']['Reason'];

                                                        }
                                                    }
                                                }
                                            } else {
                                                if (z_update_transaction($dbc, $transaction_uid, $data['PaymentResponse']['Reason'], "CANCELLED", 0)) {

                                                    $response['statusCode'] = 500;
                                                    //$response['message'] = 'Transaction Declined, Please check your balance or Contact your bank';
                                                    $response['message'] = $data['PaymentResponse']['Reason'];
                                                }
                                            }
                                        } else {
                                            $response['statusCode'] = 500;
                                            $response['message'] = 'Error initiating transaction';
                                        }
                                    } else {
                                        $response['statusCode'] = 500;
                                        $response['message'] = 'Debit Card Option Not activated';
                                    }
                                } else {
                                    $response['statusCode'] = 500;
                                    $response['message'] = 'Debit Card Option Not activated';
                                }
                            } else {
                                // Sorry, Error authenticating user!
                                $response['statusCode'] = 500;
                                $response['message'] = 'Sorry, Error authenticating user!';
                            }
                            echo json_encode($response);

                            break;
                        CASE 411: // Hubtel Pull
                            $response = array();
                            $sendPhoneNum = html_filter($dbc, $_REQUEST['senderPhone']);
                            if($source == '1'){
                                $sendPhoneNum = "+".html_filter($dbc, $_REQUEST['senderPhone']);
                            }
                            $keyCode = html_filter($dbc, $_REQUEST['keyCode']);

                            $pull_status = 'on';
                            if($pull_status == 'on') {

                                $mm_phoneNum = html_filter($dbc, $_REQUEST['mm_phone']);
                                $mm_channel = html_filter($dbc, $_REQUEST['mm_channel']);
                                $mm_Name = html_filter($dbc, $_REQUEST['mm_name']);
                                $mm_amount = html_filter($dbc, $_REQUEST['mm_amount']);
                                $mm_email = html_filter($dbc, $_REQUEST['mm_email']);
                                $mm_transactionType = html_filter($dbc, $_REQUEST['mm_transactionType']);
                                $mm_desc = "Load GN Mobile Money";
                                if ($mm_email == "" OR $mm_email == null) {
                                    $mm_email = "alert@payappglobal.com";
                                }

                                if (check_phoneNum_and_keyCode($dbc, $sendPhoneNum, $keyCode)) {
                                    $system_status = get_system_status_by_serviceType($dbc, "HUBTEL");
                                    if ($system_status['status'] == 'ON') {

                                        $customerData = get_customer_by_phoneNum($dbc, $sendPhoneNum);
                                        if($customerData['hubtel_pull_status'] == 'ON') {                                            $hubtelData = hubtelPull($dbc, $mm_Name, $mm_phoneNum, $mm_email, $mm_channel, genTransactionID(), $mm_amount, $mm_desc);
                                            if ($hubtelData['ResponseCode'] == "0001") {
                                                $transaction_uid = $hubtelData['Data']['ClientReference'];
                                                $hubtel_txn = $hubtelData['Data']['TransactionId'];
                                                $transactionStatus = 'WAITING';
                                                if (add_to_hubtel_transaction($dbc, $mm_phoneNum, $mm_transactionType, $mm_channel, $hubtelData, $customerData, 'SMART', $hubtel_txn, $transaction_uid, $transactionStatus, '')) {
                                                    $response['statusCode'] = 200;
                                                    $response['message'] = 'Check your phone, and accept the request popped up on your phone to complete the transaction';
                                                } else {
                                                    $response['statusCode'] = 500;
                                                    $response['message'] = 'Wrong information provided, Pleas try again';
                                                }
                                            } else {
                                                // Sorry, Error authenticating user!
                                                $response['statusCode'] = 500;
                                                $response['message'] = 'Error Performing transactions';
                                            }
                                        }else{
                                            $response['statusCode'] = 500;
                                            $response['message'] = 'Visit any GN Mobile Money Branch or GNBank to complete your details to use this Service';

                                        }
                                    } else {
                                        $response['statusCode'] = 500;
                                        $response['message'] = 'This service is currently Unavailable, Try again later';
                                    }
                                } else {
                                    // Sorry, Error authenticating user!
                                    $response['statusCode'] = 500;
                                    $response['message'] = 'Sorry, Error authenticating user!';
                                }
                            } else {
                                $response['statusCode'] = 500;
                                $response['message'] = 'Sorry, Service currently not available';
                            }
                            echo json_encode($response);

                            break;
                        CASE 412: // Hubtel Push
                            $response = array();
                            $sendPhoneNum = html_filter($dbc, $_REQUEST['senderPhone']);
                            if($source == '1'){
                                $sendPhoneNum = "+".html_filter($dbc, $_REQUEST['senderPhone']);
                            }
                            $keyCode = html_filter($dbc, $_REQUEST['keyCode']);

                            $mm_phoneNum = html_filter($dbc, $_REQUEST['mm_phone']);
                            $mm_channel = html_filter($dbc, $_REQUEST['mm_channel']);
                            //$mm_Name = html_filter($dbc, $_REQUEST['mm_name']);
                            $mm_Name = 'GN Money';
                            $mm_amount = html_filter($dbc, $_REQUEST['mm_amount']);
                            $mm_email = html_filter($dbc, $_REQUEST['mm_email']);
                            $mm_transactionType = html_filter($dbc, $_REQUEST['mm_transactionType']);
                            $mm_desc = "Send Money out of GN Mobile Money";
                            if ($mm_email == "" OR $mm_email == null) {
                                $mm_email = "alert@payappglobal.com";
                            }

                            if (check_phoneNum_and_keyCode($dbc, $sendPhoneNum, $keyCode)) {

                                $customerData = get_customer_by_phoneNum($dbc, $sendPhoneNum);

                                $fee = $mm_amount * 0.01; // Fee for cash out
                                $mm_amount = $mm_amount * 1;
                                $mm_totalAmount = $fee + $mm_amount;
                                if (dailyKyc($dbc, $customerData['id'], $customerData['countryCode'], $mm_amount, $fee)) {
                                    if (monthlyKyc($dbc, $customerData['id'], $customerData['countryCode'], $mm_amount, $fee)) {
                                        $system_status = get_system_status_by_serviceType($dbc, "HUBTEL");
                                        if ($system_status['status'] == 'ON') { // service status

                                            if (check_existing_balance($dbc, $customerData['id'], $mm_totalAmount)) {
                                                $hubtelData = hubtelPush($dbc, $mm_Name, $mm_phoneNum, $mm_email, $mm_channel, genTransactionID(), $mm_amount, $mm_desc);

                                                if ($hubtelData['ResponseCode'] == "0000") {

                                                    $transaction_uid = $hubtelData['Data']['ClientReference'];
                                                    $hubtel_txn = $hubtelData['Data']['TransactionId'];
                                                    if (redraw_funds($dbc, $customerData['id'], $mm_totalAmount)) {

                                                        $global_hubtel_Acc = get_customer_by_phoneNum($dbc, "+233770000000");

                                                        if (add_funds($dbc, $global_hubtel_Acc['id'], $mm_amount)) {
                                                            if (add_to_hubtel_transaction($dbc, $mm_phoneNum, $mm_transactionType, $mm_channel, $hubtelData, $customerData, 'SMART', $hubtel_txn, $transaction_uid, "COMPLETED", $fee)) {
                                                                $transactionData = get_hub_transactionData($dbc, $transaction_uid);
                                                                $transactionData['senderCountryCode'] = $customerData['countryCode'];
                                                                $transactionData['senderID'] = $customerData['id'];
                                                                $transactionData['transactionTypes'] = 'MM-PUSH';
                                                                $customerAcc = get_cus_account_info_by_customerID($dbc, $customerData['id']);
                                                                if (add_payGlobal_commission($dbc, $transactionData, $fee)) {
                                                                    if (update_hubtel_balance($dbc, $transaction_uid, $customerAcc['balance'])) {
                                                                        $customerMessage = "You have successfully Moved an amount {$mm_amount} from your GN mobile money to another Mobile Money service. transaction ID: {$transaction_uid}. balance: {$customerAcc['balance']}";
                                                                        sendSMS($customerData['phoneNum'], $customerMessage);
                                                                        if ($customerData['firebaseKey'] != '') {
                                                                            firebaseCall($customerData['firebaseKey'], $customerMessage);
                                                                        }
                                                                        $response['statusCode'] = 200;
                                                                        $response['message'] = 'You have successfully cash out from GN mobile Money';
                                                                    }
                                                                }
                                                            } else {
                                                                $response['statusCode'] = 500;
                                                                $response['message'] = 'Wrong information provided, Pleas try again';
                                                            }
                                                        }


                                                    }

                                                } elseif ($hubtelData['ResponseCode'] == "0001") {

                                                    $transaction_uid = $hubtelData['Data']['ClientReference'];
                                                    $hubtel_txn = $hubtelData['Data']['TransactionId'];
                                                    if (redraw_funds($dbc, $customerData['id'], $mm_totalAmount)) {

                                                        $global_hubtel_Acc = get_customer_by_phoneNum($dbc, "+233770000000");

                                                        if (add_funds($dbc, $global_hubtel_Acc['id'], $mm_amount)) {
                                                            if (add_to_hubtel_transaction($dbc, $mm_phoneNum, $mm_transactionType, $mm_channel, $hubtelData, $customerData, 'SMART', $hubtel_txn, $transaction_uid, "WAITING", $fee)) {
                                                                $transactionData = get_hub_transactionData($dbc, $transaction_uid);
                                                                $transactionData['senderCountryCode'] = $customerData['countryCode'];
                                                                $transactionData['senderID'] = $customerData['id'];
                                                                $transactionData['transactionTypes'] = 'MM-PUSH';
                                                                $customerAcc = get_cus_account_info_by_customerID($dbc, $customerData['id']);
                                                                if (add_payGlobal_commission($dbc, $transactionData, $fee)) {
                                                                    if (update_hubtel_balance($dbc, $transaction_uid, $customerAcc['balance'])) {

                                                                        $response['statusCode'] = 200;
                                                                        $response['message'] = 'You have successfully cash out from GN mobile Money';

                                                                    }
                                                                }
                                                            } else {
                                                                $response['statusCode'] = 500;
                                                                $response['message'] = 'Wrong information provided, Pleas try again';
                                                            }
                                                        }


                                                    }


                                                } else {
                                                    // Sorry, Error authenticating user!
                                                    // $message = $hubtelData['ResponseCode'] . " Error for all 2";
                                                    // mail("ricky@payappglobal.com", "Error2", $message);
                                                    $response['statusCode'] = 500;
                                                    $response['message'] = $hubtelData;

                                                }
                                            } else {
                                                $response['statusCode'] = 500;
                                                $response['message'] = 'You do not have enough balance in wallet';
                                            }
                                        } else {
                                            $response['statusCode'] = 500;
                                            $response['message'] = 'This service is unavailable at the moment, Try again later.';
                                        }
                                    } else {
                                        $response['statusCode'] = 500;
                                        $response['message'] = 'You have reached your daily transaction limit. Thank You';
                                    }
                                } else {
                                    $response['statusCode'] = 500;
                                    $response['message'] = 'You have reached your Monthly transaction limit. Thank You';
                                }

                            } else {
                                // Sorry, Error authenticating user!
                                $response['statusCode'] = 500;
                                $response['message'] = 'Sorry, Error authenticating user!';

                            }
                            echo json_encode($response);

                            break;

                        CASE 413:// profile status check before adding visa card
                            $response = array();
                            $phoneNum = html_filter($dbc, $_REQUEST['senderPhone']);
                            if($source == '1'){
                                $phoneNum = "+".html_filter($dbc, $_REQUEST['senderPhone']);
                            }
                            $keyCode = html_filter($dbc, $_REQUEST['keyCode']);


                            if (check_phoneNum_and_keyCode($dbc, $phoneNum, $keyCode)) {
                                $customerData = get_customer_by_phoneNum($dbc, $phoneNum);
                                if ($customerData['idNumber'] == "" OR $customerData['idType'] == "" OR $customerData['fullName'] == "" OR $customerData['address'] == "") {
                                    $response['statusCode'] = 500;
                                    $response['message'] = 'Your profile is not fully updated';
                                } else {
                                    $response['statusCode'] = 200;
                                    $response['message'] = 'SUCCESSFUL';
                                }
                            } else {
                                // Sorry, Error authenticating user!
                                $response['statusCode'] = 500;
                                $response['message'] = 'Sorry, Error authenticating user!';

                            }
                            echo json_encode($response);

                            break;

                        CASE 414:   // app  status
                            $response = array();
                            $phoneNum = html_filter($dbc, $_REQUEST['senderPhone']);
                            if($source == '1'){
                                $phoneNum = "+".html_filter($dbc, $_REQUEST['senderPhone']);
                            }
                            $keyCode = html_filter($dbc, $_REQUEST['keyCode']);


                            if (check_phoneNum_and_keyCode($dbc, $phoneNum, $keyCode)) {
                                $system_status = get_system_status_by_serviceType($dbc,"APP");
                                if($system_status['status'] == 'OFF') {
                                    $response['statusCode'] = 400;
                                    $response['message'] = 'Service Not available at the moment';
                                }else{
                                    $response['statusCode'] = 200;
                                    $response['message'] = 'Service Online';
                                }
                            } else {
                                // Sorry, Error authenticating user!
                                $response['statusCode'] = 500;
                                $response['message'] = 'Sorry, Error authenticating user!';

                            }
                            echo json_encode($response);

                            break;

                        CASE 415:   // APP LOGIN FROM SERVER
                            $response = array();
                            $phoneNum = html_filter($dbc, $_REQUEST['phoneNum']);
                            $password = passwordHash($_REQUEST['password'], $mySalt);
                            if($source == '1'){
                                $phoneNum = "+".html_filter($dbc, $_REQUEST['phoneNum']);
                            }
                            $keyCode = html_filter($dbc, $_REQUEST['keyCode']);


                            if (check_phoneNum_and_keyCode($dbc, $phoneNum, $keyCode)) {

                                if (check_phoneNum_and_password($dbc, $phoneNum, $password)) {
                                    $response['statusCode'] = 200;
                                    $response['message'] = 'Login Success';
                                } else {
                                    $response['statusCode'] = 500;
                                    $response['message'] = 'Sorry, Wrong username or password';
                                }

                            } else {
                                // Sorry, Error authenticating user!
                                $response['statusCode'] = 500;
                                $response['message'] = 'Sorry, Error authenticating user!';

                            }
                            echo json_encode($response);

                            break;

                        CASE 416:   // List of service providers
                            $response = array();
                            $phoneNum = html_filter($dbc, $_REQUEST['phoneNum']);
                            if($source == '1'){
                                $phoneNum = "+".html_filter($dbc, $_REQUEST['phoneNum']);
                            }
                            $keyCode = html_filter($dbc, $_REQUEST['keyCode']);


                            $serviceData = get_all_service_providers($dbc);
                            $response['statusCode'] = 200;
                            $response['message'] = 'Successful';
                            $response['services'] = $serviceData;

                            echo json_encode($response);

                            break;

                        CASE 417:   // List of service providers
                            $response = array();
                            $phoneNum = html_filter($dbc, $_REQUEST['phoneNum']);
                            if($source == '1'){
                                $phoneNum = "+".html_filter($dbc, $_REQUEST['phoneNum']);
                            }
                            $linked = bank_get_linked_accounts($phoneNum);
                            $accountArray = array();
                            $accountArray['1'] = $linked['account1'];
                            $accountArray['2'] = $linked['account2'];
                            $accountArray['3'] = $linked['account3'];

                            if($linked['account1'] == null){
                                $accountArray['1'] = "null";
                            }
                            if($linked['account2'] == null){
                                $accountArray['2'] = "null";
                            }
                            if($linked['account3'] == null){
                                $accountArray['3'] = "null";
                            }
                            //$linkedArray = array($linked['account1'], $linked['account2'], $linked['account3']);

                            $response['statusCode'] = 200;
                            $response['data'] = $accountArray;

                            echo json_encode($response);

                            break;

                        CASE 418:   // List all profiles
                            $response = array();
                            $phoneNum = html_filter($dbc, $_REQUEST['phoneNum']);
                            if($source == '1'){
                                $phoneNum = "+".html_filter($dbc, $_REQUEST['phoneNum']);
                            }

                            $profile = get_customer_by_phoneNum($dbc,$phoneNum);


                            $response['statusCode'] = 200;
                            $response['data'] = $profile;

                            echo json_encode($response);

                            break;


                        default:
                            echo("Sorry, Such request do not exist!");
                        break;


                    }
                } else {
                    echo("Sorry, Such http request do not exist!");
                }
            } else {
                echo "Sorry, No request Made!";
            }
        } else{
            sendSMS($appNumber,"Please update your Application to the latest version to stop PayGlobal from crashing");
        }
    } else {
        echo "CMID";
    }

} else {
    echo "Error Request Type";
    $response['statusCode'] = 500;
    $response['message'] = 'Error Request Type';
}
//print_r($_SERVER['HTTP_USER_AGENT']);

echo json_encode($response);
