<?php
function html_filter($dbc,$myVariable){
    $var = mysqli_real_escape_string($dbc,$myVariable);
    $var = htmlspecialchars($var, ENT_QUOTES | ENT_SUBSTITUTE | ENT_HTML5, 'UTF-8');
    return trim($var);
}


function get_all_country($dbc){
    $q = mysqli_query($dbc,"SELECT * FROM usercountry_tbl ");
    $data = array();
    while($rows = mysqli_fetch_assoc($q)){
        $data[] = $rows;
    }
    return $data;
}
function get_system_country($dbc){
    $q = mysqli_query($dbc,"SELECT * FROM country_tbl ");
    $data = array();
    while($rows = mysqli_fetch_assoc($q)){
        $data[] = $rows;
    }
    return $data;
}
function get_system_country_by_countryCode($dbc,$countryCode){
    $q = mysqli_query($dbc,"SELECT * FROM country_tbl WHERE countryCode = '$countryCode' ");
    $data = mysqli_fetch_assoc($q);
    return $data;
}
function get_country_by_id($dbc,$id){
    $q = mysqli_query($dbc,"SELECT * FROM usercountry_tbl WHERE id = '$id'");
    $data = mysqli_fetch_assoc($q);
    return $data;
}

function activity_log($dbc,$activity,$action){
    $userID = $_SESSION['uid'];
    $q = mysqli_query($dbc,"INSERT INTO activity_log (userID,activity,action) VALUES ('$userID','$activity','$action')");
    if($q){
        return true;
    }
}

function passwordHash($password,$mySalt){
    $password = $password.$mySalt;
    $password =  md5($password);
    $password = sha1($password.$mySalt);
    $password = md5($password.$mySalt);
    return $password;

}

function check_if_country_exist($dbc,$countryCode){
    $query = "SELECT * FROM country_tbl WHERE countryCode = '$countryCode'";
    $q = mysqli_query($dbc,$query);
    if(mysqli_num_rows($q) > 0){
        return true;
    }
}

function add_new_country($dbc,$countryName,$countryCode,$callCode,$currency){
    $q = mysqli_query($dbc,"INSERT INTO country_tbl (countryName, countryCode, callCode, currency) VALUES ('$countryName','$countryCode','$callCode','$currency')");
    if($q){
        return true;
    }
}

function get_country_code_with_currency($dbc,$countryCode){
    $q = mysqli_query($dbc,"SELECT * FROM country_tbl WHERE countryCode = '$countryCode'");
    $data = mysqli_fetch_assoc($q);
    return $data;
}

function verify_password($dbc,$password,$phoneNum){
    //$password = passwordHash($password,$mySalt);
    $q = mysqli_query($dbc,"SELECT * FROM customer_tbl WHERE phoneNum = '$phoneNum' AND password = '$password'");
    if(mysqli_num_rows($q) > 0){
        return true;
    }
}

function check_header_auth($dbc,$kiv,$ksp){
    $q = mysqli_query($dbc,"SELECT * FROM keycodeauth_tbl WHERE kiv = '$kiv' AND ksp = '$ksp'");
    if(mysqli_num_rows($q) > 0){
        return true;
    }
}

function get_conversion_rate($dbc,$fromCountryCode,$toCountryCode){
    $q = mysqli_query($dbc,"SELECT conversionRate FROM currencyexchange_tbl WHERE convertFrom = '$fromCountryCode' AND convertTo = '$toCountryCode'");
    $data = mysqli_fetch_assoc($q);
    return $data['conversionRate'];
}

function convert_money($dbc,$fromCountryCode,$toCountryCode,$amount){
    /*
     * Convert Amount to USD and to destination Currency
     */
    $data = debit_forex_main($dbc,$amount,$fromCountryCode,$toCountryCode);

    return $data;
}
function newRandomString($length = 26) {
    $str = "";
    $characters = array_merge(range('A','Z'), range('a','z'), range('0','9'));
    $max = count($characters) - 1;
    for ($i = 0; $i < $length; $i++) {
        $rand = mt_rand(0, $max);
        $str .= $characters[$rand];
    }

    return date('ymd').$str;
}

function tokenGen1($length = 6) {

    $characters = '0123456789ABCDEFGHIJKLMNPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}
function tokenGen2($length = 6) {
    $characters = '0123456789ABCDEFGHIJKLMNPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}
function tokenGenerator(){
    $str = date('m').tokenGen1().date('y').tokenGen2().date('d');
    return $str;
}

function genTransactionID($length = 10){
    $characters = '123456789ABCDEFGHIJKLMNPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString.date('dym');
}

function genBankTransactionID_main($length = 6){
    $characters = '123456789';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return date('myd').$randomString;
}

function genSMSCode($length = 6){
    $characters = '0123456789';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return trim($randomString);
}

function get_KYC_by_countryCode_and_name($dbc,$countryCode,$name){
    $q = mysqli_query($dbc,"SELECT * FROM kyc_tbl WHERE name = '$name' AND countryCode = '$countryCode'");
    $data = mysqli_fetch_assoc($q);
    return $data;
}

function get_KYC_by_id($dbc,$id,$countryCode){
    $q = mysqli_query($dbc,"SELECT * FROM kyc_tbl WHERE id = '$id' AND countryCode = '$countryCode'");
    $data = mysqli_fetch_assoc($q);
    return $data;
}

function dailyKyc($dbc,$customerID,$countryCode,$amount,$fee){
    $customerData = get_customer_by_id($dbc,$customerID);
    $kycData = get_KYC_by_id($dbc,$customerData['accountKYC'],$countryCode);

    $dailyTrans = get_customer_daily_transaction($dbc,$customerID);

    //daily kyc
    $dailyTotal = $amount + $dailyTrans;
    if($dailyTotal <= $kycData['dailyAmount']){
        return true;
    }

}

function monthlyKyc($dbc,$customerID,$countryCode,$amount,$fee){
    $customerData = get_customer_by_id($dbc,$customerID);
    $kycData = get_KYC_by_id($dbc,$customerData['accountKYC'],$countryCode);

    $monthlyTrans = get_customer_monthly_transaction($dbc,$customerID);

    //monthly kyc
    $monthlyTotal = $amount + $monthlyTrans;
    if($monthlyTotal <= $kycData['monthlyAmount']){
        return true;
    }

}

function balanceKyc($dbc,$recipientID,$countryCode,$amount,$fee){
    $customerData = get_customer_by_id($dbc,$recipientID);
    $cus_acc = get_cus_account_info_by_customerID($dbc,$recipientID);
    $kycData = get_KYC_by_id($dbc,$customerData['accountKYC'],$countryCode);

    $cus_balance = $cus_acc['balance'] + $amount + $fee;

    if($kycData['balance'] <= $cus_balance){
        return true;
    }

}
function gen_USSD_PIN($length = 4){
    $characters = '0123456789';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}

function moneyFormat($amount){
    $value = number_format($amount, 2, '.', ',');
    //$value = money_format("%i", $amount);
    return $value;
}

function moneyFormat2($amount){
    $value = number_format($amount, 2, '.', ',');
    //$value = money_format("%i", $amount);
    return $value;
}

function check_if_transaction_uid_exist_at_bank_transaction($dbc,$transaction_uid){
    $q = mysqli_query($dbc,"SELECT * FROM maintransaction_tbl WHERE transaction_uid = '$transaction_uid'");
    if(mysqli_num_rows($q) > 0){
        return true;
    }

}

function check_if_transaction_uid_exist_at_bank_transaction_waiting($dbc,$transaction_uid){
    $q = mysqli_query($dbc,"SELECT * FROM maintransaction_tbl WHERE transaction_uid = '$transaction_uid' AND transactionStatus = 'WAITING'");
    if(mysqli_num_rows($q) > 0){
        return true;
    }

}

function check_if_transaction_uid_exist_at_hubtel_transaction($dbc,$transaction_uid,$transactionType,$hubtel_tnx){
    $q = mysqli_query($dbc,"SELECT * FROM hub_transaction_tbl WHERE (transaction_uid = '$transaction_uid' AND hubtel_txn = '$hubtel_tnx') AND transactionType = '$transactionType'");
    if(mysqli_num_rows($q) > 0){
        return true;
    }

}

function get_all_transit_resolved($dbc){
    $q = mysqli_query($dbc,"SELECT * FROM transitResolver_tbl ORDER BY dateTime DESC LIMIT 300 ");
    $data = array();
    while($rows = mysqli_fetch_assoc($q)){
        $data[] = $rows;
    }
    return $data;
}

function get_all_hubtel_resolved($dbc){
    $q = mysqli_query($dbc,"SELECT * FROM hubtel_resolver_tbl ORDER BY dateTime DESC LIMIT 300 ");
    $data = array();
    while($rows = mysqli_fetch_assoc($q)){
        $data[] = $rows;
    }
    return $data;
}
 function get_mass_transaction_by_Batch_no($dbc,$batch_id){
     $query = "
        SELECT * FROM mass_transitions_tbl WHERE batch_id = '$batch_id' AND posting_status = 'PENDING' AND approval_level_2 = 'APPROVED' 
    ";
     $q = mysqli_query($dbc,$query);
     $data = array();
     while ($row = mysqli_fetch_assoc($q)){
         $data[] = $row;
     }
     return $data;
 }

 function get_uuid($dbc){
    $q = mysqli_query($dbc,"SELECT UUID() AS id");
    $data = mysqli_fetch_assoc($q);
    return $data['id'];
 }

function mass_html_filter($dbc, $inputArray)
{
    $outputArray = [];
    foreach ($inputArray as $key => $value) {
        $outputArray[$key] = html_filter($dbc, $value);
    }
    return $outputArray;
}

function get_system_number_by_name($dbc,$name,$country){
    $q = mysqli_query($dbc,"SELECT * FROM system_numbers_tbl WHERE name = '$name' AND country = '$country'");
    $data = mysqli_fetch_assoc($q);
    return $data;
}