<?php
include "config/init.php";
include "template/header.php";
//Main Header
include "template/main-header.php";
//Left side column. contains the logo and sidebar -->
include "template/main-sidebar.php";

// Submit new country Data
if(isset($_POST['add_country'])){
    if(!empty($_POST['countryName']) && !empty($_POST['countryCode']) && !empty($_POST['callCode']) && !empty($_POST['currency'])){
        $countryName = html_filter($dbc,$_POST['countryName']);
        $countryCode = html_filter($dbc,$_POST['countryCode']);
        $callCode = html_filter($dbc,$_POST['callCode']);
        $currency = html_filter($dbc,$_POST['currency']);


            if(check_if_country_exist($dbc,$countryCode)){
                $result = "<p class='alert alert-danger'>Country Already Exist</p>";
            } else{
                if(add_new_country($dbc,$countryName,$countryCode,$callCode,$currency)){
                    $result = "<p class='alert alert-success'>A new Country Added</p>";
                }else{
                    $result = "<p class='alert alert-danger'>An Error Occur.</p>";
                }
            }

    } else{
        $result = "<p class='alert alert-danger'>All fields Required</p>";
    }
}
?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                Country Management
            </h1>
            <ol class="breadcrumb">
                <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
                <li class="active">Country Management</li>
            </ol>
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="row">
                <?php
                if (isset($result)){ echo $result; }
                ?>
                <div class="col-md-5">
                    <div class="box box-default">
                        <div class="box-header with-border">Add Country</div>
                        <div class="box-body">
                            <form role="form" method="post">
                                <div class="form-group">
                                    <label for="countryName">Country Name</label>
                                    <input type="text" name="countryName" required class="form-control" id="countryName" placeholder="Eg. Ghana">
                                </div>
                                <div class="form-group">
                                    <label for="countryCode">Country code</label>
                                    <input type="text" name="countryCode" required class="form-control" id="countryCode" placeholder="Eg. gh">
                                </div>
                                <div class="form-group">
                                    <label for="callCode">Call Code</label>
                                    <input type="text" name="callCode" required class="form-control" id="callCode" placeholder="Eg. +233">
                                </div>
                                <div class="form-group">
                                    <label for="currency">Currency</label>
                                    <input type="text" name="currency" required class="form-control" id="currency" placeholder="Eg. GHC">
                                </div>
                                <button type="submit" class="btn btn-primary" name="add_country">Add Country</button>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="col-md-7">
                    <div class="box box-success">
                        <div class="box-body">
                            <table class="table" role="table" id="systemCountry">
                                <thead>
                                <tr>
                                    <th>id</th>
                                    <th>Country</th>
                                    <th>Code</th>
                                    <th>Call Code</th>
                                    <th>Currency</th>
                                    <th>Date Added</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                    $countryLists = get_system_country($dbc);
                                    foreach ($countryLists as $countryList){
                                ?>
                                        <tr>
                                            <td><?=$countryList['id']?></td>
                                            <td><?=$countryList['countryName']?></td>
                                            <td><?=$countryList['countryCode']?></td>
                                            <td><?=$countryList['callCode']?></td>
                                            <td><?=$countryList['currency']?></td>
                                            <td><?=$countryList['dateTime']?></td>
                                        </tr>
                                <?php
                                    }
                                ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?php include "template/footer.php"?>


