<?php
include "config/init.php";
include "template/header.php";
//Main Header
include "template/main-header.php";
//Left side column. contains the logo and sidebar -->
include "template/main-sidebar.php";


// Update Exchange Rate
if(isset($_POST['rate'])){
    $rate = html_filter($dbc,$_POST['rate']);
    if(!empty($rate)){
        if(update_exchangeRate($dbc,$_GET['c_edit'],$rate)){
            $result = "<p class='alert alert-success'>Rate Updated</p>";
        }else{
            $result = "<p class='alert alert-danger'>Error!, Please try Later</p>";
        }
    } else{
        $result = "<p class='alert alert-danger'>Fields is Required</p>";
    }
}

// Edit service Pricing
if(isset($_GET['c_edit'])){
    $exchange_data = get_currency_mgt_by_id($dbc,$_GET['c_edit']);
    if($exchange_data['id'] == ''){
        header("Location:currency-mgt.php");
        die();
    }
}


?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Customer Account Type
        </h1>
        <ol class="breadcrumb">
            <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Customer Account Type</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <?php if(isset($result)){echo $result;} ?>
        <div class="row">
            <div class="col-md-4">
                <div class="box box-primary">
                    <?php
                    if(isset($_GET['c_edit'])){
                        // Update account Type Section
                        ?>
                        <div class="box-header with-border">Update Exchange</div>
                        <div class="box-body">
                            <form role="form" method="post">
                                <div class="form-group">
                                    <label for="from">Convert From</label>
                                    <input type="text" name="from" class="form-control" disabled id="from" required value="<?=$exchange_data['convertFrom']?>">
                                </div>
                                <div class="form-group">
                                    <label for="to">Convert to</label>
                                    <input type="text" name="to" class="form-control" disabled id="to" required value="<?=$exchange_data['convertTo']?>">
                                </div>
                                <div class="form-group">
                                    <label for="rate">Rate</label>
                                    <input type="number" step="any" name="rate" class="form-control" id="rate" required value="<?=$exchange_data['conversionRate']?>">
                                </div>
                                <button type="submit" class="btn-block btn btn-primary" name="update-exchange">Submit</button>
                            </form>
                        </div>
                        <?php
                    } else{
                        ?>

                        <?php
                    }
                    ?>
                </div>
            </div>
            <div class="col-md-8">
                <div class="box box-success">
                    <div class="box-header with-border">List of Exchange</div>
                    <div class="box-body">
                        <table class="table table-striped" id="currencyExchange">
                            <thead>
                            <tr>
                                <th>ID</th>
                                <th>FROM</th>
                                <th>TO</th>
                                <th>RATE</th>
                                <th>ADDED DATE</th>
                                <th>UPDATED BY</th>
                                <th>UPDATED DATE</th>
                                <th>EDIT</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php
                            $currencyMgtLists = get_currency_mgt($dbc);
                            foreach ($currencyMgtLists as $currencyMgtList){
                                $user = get_user_by_id($dbc,$currencyMgtList['updated_by']);
                                ?>
                                <tr>
                                    <td><?=$currencyMgtList['id']?></td>
                                    <td><?=$currencyMgtList['convertFrom']?></td>
                                    <td><?=$currencyMgtList['convertTo']?></td>
                                    <td><?=$currencyMgtList['conversionRate']?></td>
                                    <td><?=$currencyMgtList['dateTime']?></td>
                                    <td><?=$user['fullName']?></td>
                                    <td><?=$currencyMgtList['updated_date']?></td>
                                    <td><a href='currency-mgt.php?c_edit=<?=$currencyMgtList['id']?>'><i class='fa fa-eye'></i></a></td>
                                </tr>
                                <?php
                            }
                            ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<?php include "template/footer.php"?>


