<?php
include "config/init.php";
include "template/header.php";
//Main Header
include "template/main-header.php";
//Left side column. contains the logo and sidebar -->
include "template/main-sidebar.php";

if($_SESSION['role'] != 'SYSTEMADMIN' || $_SESSION['role'] != 'ADMINISTRATOR'){
    header("location:index.php");
    die();
}

// add new service pricing
if(isset($_POST['add-group'])){
    $groupName = html_filter($dbc,$_POST['groupName']);
    if(!empty($groupName)){
        if(add_new_group($dbc,$groupName)){
            $result = "<p class='alert alert-success'>New Customer Group Added</p>";
        }else{
            $result = "<p class='alert alert-danger'>Error!, Please try Later</p>";
        }
    } else{
        $result = "<p class='alert alert-danger'>Fields is Required</p>";
    }
}

// Edit service Pricing
if(isset($_GET['edit_cus_type'])){
    $service_data = get_service_pricing_by_id($dbc,$_GET['edit_service']);
    if($service_data['id'] == ''){
        header("Location:service-pricing.php");
        die();
    }
}


?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Customer Account Type
        </h1>
        <ol class="breadcrumb">
            <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Customer Account Type</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <?php if(isset($result)){echo $result;} ?>
        <div class="row">
            <div class="col-md-4">
                <div class="box box-primary">
                    <?php
                    if(isset($_GET['edit_group'])){
                        // Update account Type Section
                        ?>
                        <?php
                    } else{
                        ?>
                        <div class="box-header with-border">Add New Group</div>
                        <div class="box-body">
                            <form role="form" method="post">
                                <div class="form-group">
                                    <label for="groupName">Group Name</label>
                                    <input type="text" name="groupName" class="form-control" id="groupName" required>
                                </div>
                                <button type="submit" class="btn-block btn btn-primary" name="add-group">Submit</button>
                            </form>
                        </div>
                        <?php
                    }
                    ?>
                </div>
            </div>
            <div class="col-md-8">
                <div class="box box-success">
                    <div class="box-header with-border">List of Customer Groups</div>
                    <div class="box-body">
                        <table class="table table-striped" id="cus_group">
                            <thead>
                            <tr>
                                <th>ID</th>
                                <th>Group Name</th>
                                <th>Added By</th>
                                <th>Date</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php
                            $customerGroupLists = get_all_from_uGroup($dbc);
                            foreach ($customerGroupLists as $customerGroupList){
                                $user = get_user_by_id($dbc,$customerGroupList['added_by']);
                                ?>
                                <tr>
                                    <td><?=$customerGroupList['id']?></td>
                                    <td><?=$customerGroupList['groupName']?></td>
                                    <td><?=$user['fullName']?></td>
                                    <td><?=$customerGroupList['dateTime']?></td>
                                </tr>
                                <?php
                            }
                            ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<?php include "template/footer.php"?>


