<?php
include "config/init.php";
include "template/header.php";
//Main Header
include "template/main-header.php";
//Left side column. contains the logo and sidebar -->
include "template/main-sidebar.php";

if(isset($_POST['generate'])){
    $amount = html_filter($dbc,$_POST['amount']);
    $quantity = html_filter($dbc,$_POST['quantity']);
    $country = html_filter($dbc,$_POST['country']);
    $exp_date = html_filter($dbc,$_POST['exp_date']);
    $phoneNum = html_filter($dbc,$_POST['phoneNum']);
    if(promoCode($dbc,$country,$exp_date,$phoneNum,$quantity,$amount)){
        $result = "<p class='alert alert-success'>Code Generated</p>";
    } else{
        $result = "<p class='alert alert-danger'>Code Generation Unsuccessful.</p>";
    }
}
?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Voucher Promo Code
        </h1>
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Voucher Promo Code</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <?php
            if(isset($result)){echo $result;}
        ?>
        <div class="row">
            <div class="col-md-5">
                <div class="box box-default">
                    <div class="box-header with-border"> Generator Form</div>
                    <div class="box-body">
                        <form method="post">
                            <div class="form-group">
                                <label  for="amount">Amount</label>
                                <input type="number" min="1" step="any" class="form-control" id="amount" name="amount" required>
                            </div>
                            <div class="form-group">
                                <label for="quantity">Quantity</label>
                                <input type="number" min="1" class="form-control" id="quantity" name="quantity" required>
                            </div>
                            <div class="form-group">
                                <label for="country">Country</label>

                                <select required class="form-control" id="country" name="country">
                                    <option value="">Select Country</option>
                                    <?php
                                    $country = get_system_country($dbc);
                                    foreach ($country as $value){
                                        ?>
                                        <option value="<?=$value['countryCode']?>"><?=strtoupper($value['countryCode'])?></option>
                                    <?php
                                    }
                                    ?>
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="companyRegDate">Expiring Date</label>
                                <input type="text" name="exp_date" id="companyRegDate" class="form-control">
                            </div>
                            <div class="form-group">
                                <label for="phoneNum">Phone Number</label>
                                <input type="text" name="phoneNum" id="phoneNum" class="form-control">
                            </div>

                            <input type="submit" value="Generate Now" class="btn btn-primary" name="generate">
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-md-7"></div>
        </div>
    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<?php include "template/footer.php"?>


