<?php
include "config/init.php";
include "template/header.php";
//Main Header
include "template/main-header.php";
//Left side column. contains the logo and sidebar -->
include "template/main-sidebar.php";

if(isset($_POST['generate'])){
    $amount = html_filter($dbc,$_POST['amount']);
    $quantity = html_filter($dbc,$_POST['quantity']);
    $country = html_filter($dbc,$_POST['country']);
    if(generate_voucher($dbc,$amount,$quantity,$country)){
        $result = "<p class='alert alert-success'>Voucher Generated</p>";
    } else{
        $result = "<p class='alert alert-success'>Voucher Generation Unsuccessful.</p>";
    }
}
?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Voucher Generator
        </h1>
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Voucher Generation</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <?php
            if(isset($result)){echo $result;}
        ?>
        <div class="row">
            <div class="col-md-5">
                <div class="box box-default">
                    <div class="box-header with-border"> Generator Form</div>
                    <div class="box-body">
                        <form method="post">
                            <div class="form-group">
                                <label for="amount">Amount</label>
                                <input type="number" min="1" step="any" class="form-control" name="amount" required>
                            </div>
                            <div class="form-group">
                                <label for="quantity">Quantity</label>
                                <input type="number" min="1" class="form-control" name="quantity" required>
                            </div>
                            <div class="form-group">
                                <label for="country">Country</label>

                                <select required class="form-control" name="country">
                                    <option value="">Select Country</option>
                                    <?php
                                    $country = get_system_country($dbc);
                                    foreach ($country as $value){
                                        ?>
                                        <option value="<?=$value['countryCode']?>"><?=strtoupper($value['countryCode'])?></option>
                                    <?php
                                    }
                                    ?>
                                </select>
                            </div>
                            <input type="submit" value="Generate Now" class="btn btn-primary" name="generate">
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-md-7"></div>
        </div>
    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<?php include "template/footer.php"?>


