<?php
//session_start();
include "config/init.php";
include "template/header.php";
//Main Header
include "template/main-header.php";
//Left side column. contains the logo and sidebar -->
include "template/main-sidebar.php";

if(isset($_POST['creditSuperAgent'])){
    $superAgent = html_filter($dbc,$_POST['superAgent']);
    $gloAccount = html_filter($dbc,$_POST['gloAccount']);
    $amount = html_filter($dbc,$_POST['amount']);
	$gloAccountData = get_all_from_gloAccount_by_id($dbc,$gloAccount);
	$globalCountryCode = $gloAccountData['countryCode'];
	$getsuperAgent = get_customer_by_id($dbc,$superAgent);
	$phoneNum = $getsuperAgent['phoneNum'];
	$countryCode = $globalCountryCode;
	
	if($getsuperAgent['countryCode']=="lr" or $getsuperAgent['countryCode']=="lr1"){	
	update_country_code($dbc,$phoneNum,$countryCode,'MULTIPLE');
	}
	
    if(!empty($superAgent) AND !empty($gloAccount) AND !empty($amount)){
        
        if($gloAccountData['balance'] >= $amount){
            if(credit_superAgent_from_gloAccount($dbc,$gloAccount,$superAgent,$amount)){
                $result = "<p class='alert alert-success'>You have sent {$amount} to a super Agent</p>";
            } else{
                $result = "<p class='alert alert-danger'>An Error Occur, Try again</p>";
            }
        }else{
            $result = "<p class='alert alert-danger'>You don't have enough Balance</p>";
        }

    } else{
        $result = "<p class='alert alert-danger'>All fields required</p>";
    }
}

?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Credit Super Agents
        </h1>
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i> Credit Super Agents</a></li>
            <li class="active">Dashboard</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <?php
            if(isset($result)){echo $result;}
        ?>
        <div class="row">
            <div class="col-md-4">
                <div class="box box-default">
                    <div class="box-header with-border">Credit Global Account</div>
                    <div class="box-body">
                        <form method="post" role="form">
                            <div class="form-group">
                                <label for="gloAccount">Global Account</label>
                                <select class="form-control" name="gloAccount" required id="gloAccount">
                                    <option value="">Select Global Account</option>
                                    <?php
                                    $gloLists = get_all_global_account($dbc);
									//var_dump($gloLists);
                                    foreach ($gloLists as $gloList){
                                        if($_SESSION['userCountry'] == $gloList['countryCode'] OR $gloList['countryCode'] == $_SESSION['userCountry']."1" OR $_SESSION['userCountry'] == 'all' ) {
                                            echo "<option value='{$gloList['id']}'>{$gloList['accountName']}</option>";
                                        }
                                        
                                    }
                                    ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="superAgent">Super Agent</label>
                                <select class="form-control" required name="superAgent" id="superAgent">
                                    <option value="">Find Super Agent</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="amount">Amount</label>
                                <input type="number" minlength="1" name="amount" id="amount" required step="any" class="form-control">
                            </div>
                            <button class="btn btn-primary" onclick="confirm('Are you sure you want to do this transaction')" name="creditSuperAgent" type="submit" id="creditSuperAgent">Credit Account</button>

                        </form>
                    </div>
                </div>
            </div>
            <div class="col-md-8">
                <div class="box box-success">
                    <div class="box-header with-border">List of Global Account</div>
                    <div class="box-body">
                        <table class="table table-striped" id="">
                            <thead>
                            <tr>
                                <th>Country</th>
                                <th>Balance</th>
                                <th>Credit</th>
                                <th>Debit</th>
                                <th>Created By</th>
                                <th>Date</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php
                            $ListDevAccount = get_all_global_account($dbc);
                            foreach($ListDevAccount as $value){
                                $countryData = get_country_code_with_currency($dbc,$value['country']);
                                $userData = get_user_by_id($dbc,$value['created_by']);
                                ?>
                                <tr>
                                    <td><?=$value['accountName'] ?></td>
                                    <td><?=$countryData['currency']." ".$value['balance'] ?></td>
                                    <td><?=$countryData['currency']." ".$value['credit'] ?></td>
                                    <td><?=$countryData['currency']." ".$value['debit'] ?></td>
                                    <td><?=$userData['fullName'] ?></td>
                                    <td><?=$value['dateTime'] ?></td>
                                </tr>
                                <?php
                            }
                            ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- List of developers Transactions -->
                <div class="box box-success">
                    <div class="box-header with-border">List of Transactions</div>
                    <div class="box-body">
                        <table class="table table-striped" id="gloAccount_transactions">
                            <thead>
                            <tr>
                                <th>Date</th>
                                <th>From</th>
                                <th>To</th>
                                <th>Amount</th>
                                <th>transaction ID</th>
                                <th>Added By</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>


            </div>
        </div>
    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<?php include "template/footer.php"?>


