<?php
include "config/init.php";
include "template/header.php";
//Main Header
include "template/main-header.php";
//Left side column. contains the logo and sidebar -->
include "template/main-sidebar.php";

$batch_id = get_uuid($dbc);
// Update Exchange Rate
if(isset($_POST['rate'])){
    $rate = html_filter($dbc,$_POST['rate']);
    if(!empty($rate)){
        if(update_exchangeRate($dbc,$_GET['c_edit'],$rate)){
            $result = "<p class='alert alert-success'>Rate Updated</p>";
        }else{
            $result = "<p class='alert alert-danger'>Error!, Please try Later</p>";
        }
    } else{
        $result = "<p class='alert alert-danger'>Fields is Required</p>";
    }
}
$forexAccounts = get_forex_account($dbc);

if(isset($_POST['submit'])){
    $b_id = html_filter($dbc,$_POST['batch_id']);
    $remark = html_filter($dbc,$_POST['remark']);

    if(!empty($b_id) AND !empty($remark)){
        foreach($forexAccounts as $forexAccount){
            $q = mysqli_query($dbc,"
            
            INSERT INTO payglobal_forex_account_settlement_tbl
            (countryCode, localAccountCredit, localAccountDebit, dominantUSDaccountCredit, dominantUSDaccountDebit, batch_no, DateTime, remark) 
            VALUES 
            ('$forexAccount[countryCode]','$forexAccount[localAccountCredit]','$forexAccount[localAccountDebit]','$forexAccount[dominantUSDaccountCredit]','$forexAccount[dominantUSDaccountDebit]','$b_id',NOW(),'$remark')
            
            ");
        }
        $result = "<p class='alert alert-success'>Resettlement Successful</p>";
    }else{
        $result = "<p class='alert alert-danger'>All fields Required</p>";
    }

}


?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Forex Accounts
        </h1>
        <ol class="breadcrumb">
            <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Forex Account</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-success">
                    <div class="box-header with-border">Forex Accounts</div>
                    <div class="box-body">
                        <table class="table table-striped" id="currencyExchange">
                            <thead>
                            <tr>
                                <th>ID</th>
                                <th>Country</th>
                                <th>Local Acc Credit</th>
                                <th>Local Acc Debit</th>
                                <th>Dominant Acc Credit</th>
                                <th>Dominant Acc Debit</th>
                                <th>Net Position</th>
                                <th>Date</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php
                            foreach ($forexAccounts as $forexAccount){
                                $currency = get_currency_by_countryCode($dbc,$forexAccount['countryCode']);
                                $netPosition = $forexAccount['dominantUSDaccountCredit'] - $forexAccount['dominantUSDaccountDebit'];
                                ?>
                                <tr>
                                    <td><?=$forexAccount['id']?></td>
                                    <td><?=$forexAccount['countryCode']?></td>
                                    <td><?=$currency['currency'].' '.$forexAccount['localAccountCredit']?></td>
                                    <td><?=$currency['currency'].' '.$forexAccount['localAccountDebit']?></td>
                                    <td>USD <?=$forexAccount['dominantUSDaccountCredit']?></td>
                                    <td>USD <?=$forexAccount['dominantUSDaccountDebit']?></td>
                                    <td>USD <?=$netPosition?></td>
                                    <td><?=$forexAccount['DateTime']?></td>
                                </tr>
                                <?php
                            }
                            ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-3">
                <?php
                    if(isset($result)){
                        echo $result;

                    }
                ?>
                <div class="box box-default">
                    <div class="box-header">Global Settlement</div>
                    <div class="box-body">
                        <form role="form" method="post">
                            <div class="form-group">
                                <label for="batch_id">Batch ID</label>
                                <input type="text" class="form-control" readonly name="batch_id" id="batch_id" value="<?=$batch_id?>">
                            </div>
                            <div class="form-group">
                                <label for="remark">Remark</label>
                                <input type="text" class="form-control" name="remark" id="remark" required>
                            </div>
                            <button class="btn btn-success" type="submit" name="submit">Submit</button>
                        </form>
                    </div>
                </div>


            </div>
        </div>
    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<?php include "template/footer.php"?>


