<?php
include "config/init.php";
include "template/header.php";
//Main Header
include "template/main-header.php";
//Left side column. contains the logo and sidebar -->
include "template/main-sidebar.php";

// add new service pricing
if(isset($_POST['add-pricing'])){
    $senderGroup = html_filter($dbc,$_POST['senderGroup']);
    $sendersAccountType = html_filter($dbc,$_POST['sendersAccountType']);
    $recipientGroup = html_filter($dbc,$_POST['recipientGroup']);
    $recipientAccountType = html_filter($dbc,$_POST['recipientAccountType']);
    $serviceType = html_filter($dbc,$_POST['serviceType']);
    $price = html_filter($dbc,$_POST['price']);
    $priceType = html_filter($dbc,$_POST['priceType']);
    $senderCountry = html_filter($dbc,$_POST['senderCountry']);
    $recipientCountry = html_filter($dbc,$_POST['recipientCountry']);
    $sysCommission = html_filter($dbc,$_POST['sysCommission']);
    $senderCommission = html_filter($dbc,$_POST['senderCommission']);
    $recipientCommission = html_filter($dbc,$_POST['recipientCommission']);
    if(!empty($senderGroup) && !empty($sendersAccountType) && !empty($recipientGroup) && !empty($recipientAccountType) && !empty($serviceType) && !empty($price) && !empty($priceType) && !empty($senderCountry) && !empty($recipientCountry) && !empty($sysCommission) && !empty($senderCommission) && !empty($recipientCommission)){
        if(add_pricing_policy($dbc,$senderGroup,$sendersAccountType,$recipientGroup,$recipientAccountType,$serviceType,$price,$priceType,$senderCountry,$recipientCountry,$sysCommission,$senderCommission,$recipientCommission)){
            $result = "<p class='alert alert-success'>New Pricing Added</p>";
        }else{
            $result = "<p class='alert alert-danger'>Error!, Please try Later</p>";
        }
    } else{
        $result = "<p class='alert alert-danger'>All Fields Required</p>";
    }
}

// Update service pricing
if(isset($_POST['update-pricing'])){
    $senderGroup = html_filter($dbc,$_POST['senderGroup']);
    $sendersAccountType = html_filter($dbc,$_POST['sendersAccountType']);
    $recipientGroup = html_filter($dbc,$_POST['recipientGroup']);
    $recipientAccountType = html_filter($dbc,$_POST['recipientAccountType']);
    $serviceType = html_filter($dbc,$_POST['serviceType']);
    $price = html_filter($dbc,$_POST['price']);
    $priceType = html_filter($dbc,$_POST['priceType']);
    $senderCountry = html_filter($dbc,$_POST['senderCountry']);
    $recipientCountry = html_filter($dbc,$_POST['recipientCountry']);
    $sysCommission = html_filter($dbc,$_POST['sysCommission']);
    $senderCommission = html_filter($dbc,$_POST['senderCommission']);
    $recipientCommission = html_filter($dbc,$_POST['recipientCommission']);
    if(!empty($senderGroup) && !empty($sendersAccountType) && !empty($recipientGroup) && !empty($recipientAccountType) && !empty($serviceType) && !empty($price) && !empty($priceType)){
        if(update_pricing_policy($dbc,$_GET['edit_pricing'],$senderGroup,$sendersAccountType,$recipientGroup,$recipientAccountType,$serviceType,$price,$priceType,$senderCountry,$recipientCountry,$sysCommission,$senderCommission,$recipientCommission)){
            $result = "<p class='alert alert-success'>Pricing Policy Updated</p>";
        }else{
            $result = "<p class='alert alert-danger'>Error!, Please try Later</p>";
        }
    } else{
        $result = "<p class='alert alert-danger'>All Fields Required</p>";
    }
}

// Edit service Pricing
if(isset($_GET['edit_pricing'])){
    $pricing_data = get_pricing_policy_by_id($dbc,$_GET['edit_pricing']);
    if($pricing_data['id'] == ''){
        header("Location:main-pricing.php");
        die();
    }
}


?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Pricing Policy
        </h1>
        <ol class="breadcrumb">
            <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Pricing Policy</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <?php if(isset($result)){echo $result;} ?>
        <div class="row">
            <div class="col-md-4">
                <div class="box box-primary">
                    <?php
                    if(isset($_GET['edit_pricing'])){
                        // Update pricing Policy

                        $senderGroup = get_uGroup_by_id($dbc,$pricing_data['senderUGroup']);
                        $senderAccType = get_accountType_by_id($dbc,$pricing_data['senderAccountType']);
                        $recipientGroup = get_uGroup_by_id($dbc,$pricing_data['recipientUGroup']);
                        $recipientAccType = get_accountType_by_id($dbc,$pricing_data['recipientAccountType']);
                        $serviceType = get_service_pricing_by_id($dbc,$pricing_data['serviceType']);

                        ?>
                        <a href="main-pricing.php" class="btn btn-info btn-block"> ADD NEW PRICING POLICY</a><br>

                        <div class="box-header with-border">Update Pricing Policy</div>
                        <div class="box-body">
                            <form role="form" method="post">
                                <div class="form-group">
                                    <label for="senderGroup">Senders Group</label>
                                    <select id="senderGroup" class="form-control" name="senderGroup" required>
                                        <option value="<?=$pricing_data['senderUGroup']?>"><?=$senderGroup['groupName']?></option>
                                        <?php
                                        $uGroupData = get_all_from_uGroup($dbc);
                                        foreach ($uGroupData as $ugroup){
                                            ?>
                                            <option value="<?=$ugroup['id']?>"><?=$ugroup['groupName']?></option>
                                            <?php
                                        }
                                        ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="recipientGroup">Recipient Group</label>
                                    <select id="recipientGroup" class="form-control" name="recipientGroup" required>
                                        <option value="<?=$pricing_data['senderUGroup']?>"><?=$recipientGroup['groupName']?></option>
                                        <?php
                                        foreach ($uGroupData as $ugroup){
                                            ?>
                                            <option value="<?=$ugroup['id']?>"><?=$ugroup['groupName']?></option>
                                            <?php
                                        }
                                        ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="sendersAccountType">Senders Account Type</label>
                                    <select id="sendersAccountType" class="form-control" name="sendersAccountType" required>
                                        <option value="<?=$senderAccType['id']?>"><?=$senderAccType['accountType']?></option>
                                        <?php
                                        $accountTypeData = get_all_from_accountType($dbc);
                                        foreach ($accountTypeData as $accountType){
                                            ?>
                                            <option value="<?=$accountType['id']?>"><?=$accountType['accountType']?></option>
                                            <?php
                                        }
                                        ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="recipientAccountType">Recipient Account Type</label>
                                    <select id="recipientAccountType" class="form-control" name="recipientAccountType" required>
                                        <option value="<?=$recipientAccType['id']?>"><?=$recipientAccType['accountType']?></option>
                                        <?php
                                        foreach ($accountTypeData as $accountType){
                                            ?>
                                            <option value="<?=$accountType['id']?>"><?=$accountType['accountType']?></option>
                                            <?php
                                        }
                                        ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="serviceType">Service Type</label>
                                    <select id="serviceType" class="form-control" name="serviceType" required>
                                        <option value="<?=$pricing_data['serviceType']?>"><?=$serviceType['serviceName']?></option>
                                        <?php
                                        $serviceTypeData = get_all_from_service_pricing($dbc);
                                        foreach ($serviceTypeData as $serviceType){
                                            ?>
                                            <option value="<?=$serviceType['id']?>"><?=$serviceType['serviceName']?></option>
                                            <?php
                                        }
                                        ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="priceType">Price Type</label>
                                    <select class="form-control" name="priceType" id="priceType" required>
                                        <option value="<?=$pricing_data['priceType']?>"><?=$pricing_data['priceType']?></option>
                                        <option value="ABSOLUTE">ABSOLUTE</option>
                                        <option value="PERCENTAGE">PERCENTAGE</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="price">Price</label>
                                    <input type="number" step="any" name="price" class="form-control" value="<?=$pricing_data['price_in_percent_absolute']?>" id="price" required>
                                </div>
                                <div class="form-group">
                                    <label for="senderCountry">Sender Country</label>

                                    <select id="senderCountry" class="form-control" name="senderCountry" required>
                                        <?php
                                            $sCountry = get_system_country_by_countryCode($dbc,$pricing_data['senderCountry'])
                                        ?>
                                        <option value="<?=$pricing_data['senderCountry']?>"><?=$sCountry['countryName']?></option>
                                        <option value="gb">Great Britain </option>
                                        
                                        <!--<option value="gh">Ghana</option>
                                        <option value="lr">Liberia USD</option>
                                        <option value="lr1">Liberia LRD</option>
                                        
                                        <option value="us">United States</option>
                                        <option value="ag">Antigua and Barbuda</option>-->
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="recipientCountry">Recipient Country</label>
                                    <select id="recipientCountry" class="form-control" name="recipientCountry" required>
                                        <?php
                                        $sCountry = get_system_country_by_countryCode($dbc,$pricing_data['recipientCountry'])
                                        ?>
                                        <option value="<?=$pricing_data['recipientCountry']?>"><?=$sCountry['countryName']?></option>
                                        <option value="gb">Great Britain </option>
                                        
                                        <option value="gh">Ghana</option>
                                        <option value="lr">Liberia USD</option>
                                        <!--<option value="lr1">Liberia LRD</option>
                                        
                                        <option value="us">United States</option>
                                        <option value="ag">Antigua and Barbuda</option>-->
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="sysCommission">PG-Sterling Commission</label>
                                    <input type="number" step="any" name="sysCommission" value="<?=$pricing_data['sysCommission']?>" class="form-control" id="sysCommission" required>
                                </div>
                                <div class="form-group">
                                    <label for="senderCommission">Sender Commission</label>
                                    <input type="number" step="any" name="senderCommission" value="<?=$pricing_data['senderCommission']?>" class="form-control" id="senderCommission" required>
                                </div>
                                <div class="form-group">
                                    <label for="recipientCommission">Recipient Commission</label>
                                    <input type="number" step="any" name="recipientCommission" value="<?=$pricing_data['recipientCommission']?>" class="form-control" id="recipientCommission" required>
                                </div>
                                <button type="submit" class="btn-block btn btn-primary" name="update-pricing">Update Pricing Policy</button>
                            </form>
                        </div>
                        <?php
                    } else{

                        // Add new pricing policy
                        ?>
                        <div class="box-header with-border">Add New Pricing</div>
                        <div class="box-body">
                            <form role="form" method="post">
                                <div class="form-group">
                                    <label for="senderGroup">Senders Group</label>
                                    <select id="senderGroup" class="form-control" name="senderGroup" required>
                                        <option value="">Select Senders Group</option>
                                        <?php
                                            $uGroupData = get_all_from_uGroup($dbc);
                                            foreach ($uGroupData as $ugroup){
                                                ?>
                                                <option value="<?=$ugroup['id']?>"><?=$ugroup['groupName']?></option>
                                        <?php
                                            }
                                        ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="recipientGroup">Recipient Group</label>
                                    <select id="recipientGroup" class="form-control" name="recipientGroup" required>
                                        <option value="">Select Recipient Group</option>
                                        <?php
                                            foreach ($uGroupData as $ugroup){
                                                ?>
                                                <option value="<?=$ugroup['id']?>"><?=$ugroup['groupName']?></option>
                                        <?php
                                            }
                                        ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="sendersAccountType">Senders Account Type</label>
                                    <select id="sendersAccountType" class="form-control" name="sendersAccountType" required>
                                        <option value="">Select Sender Account Type</option>
                                        <?php
                                            $accountTypeData = get_all_from_accountType($dbc);
                                            foreach ($accountTypeData as $accountType){
                                                ?>
                                                <option value="<?=$accountType['id']?>"><?=$accountType['accountType']?></option>
                                        <?php
                                            }
                                        ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="recipientAccountType">Recipient Account Type</label>
                                    <select id="recipientAccountType" class="form-control" name="recipientAccountType" required>
                                        <option value="">Select Recipient Account Type</option>
                                        <?php
                                            foreach ($accountTypeData as $accountType){
                                                ?>
                                                <option value="<?=$accountType['id']?>"><?=$accountType['accountType']?></option>
                                        <?php
                                            }
                                        ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="serviceType">Service Type</label>
                                    <select id="serviceType" class="form-control" name="serviceType" required>
                                        <option value="">Select Service</option>
                                        <?php
                                            $serviceTypeData = get_all_from_service_pricing($dbc);
                                            foreach ($serviceTypeData as $serviceType){
                                                ?>
                                                <option value="<?=$serviceType['id']?>"><?=$serviceType['serviceName']?></option>
                                        <?php
                                            }
                                        ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="priceType">Price Type</label>
                                    <select class="form-control" name="priceType" id="priceType" required>
                                        <option value="">Select Price Type</option>
                                        <option value="ABSOLUTE">ABSOLUTE</option>
                                        <option value="PERCENTAGE">PERCENTAGE</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="price">Price</label>
                                    <input type="number" step="any" name="price" class="form-control" id="price" required>
                                </div>
                                <div class="form-group">
                                    <label for="senderCountry">Sender Country</label>
                                    <select id="senderCountry" class="form-control" name="senderCountry" required>
                                        <option value="">Select Country Code</option>
                                        <option value="gb">Great Britain </option>
                                        
                                        <!--<option value="gh">Ghana</option>
                                        <option value="lr">Liberia USD</option>
                                        <option value="lr1">Liberia LRD</option>
                                        
                                        <option value="us">United States</option>
                                        <option value="ag">Antigua and Barbuda</option>-->
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="recipientCountry">Recipient Country</label>
                                    <select id="recipientCountry" class="form-control" name="recipientCountry" required>
                                        <option value="">Select Country Code</option>
                                        <option value="gb">Great Britain </option>
                                        
                                        <option value="gh">Ghana</option>
                                        <option value="lr">Liberia USD</option>
                                        <!--<option value="lr1">Liberia LRD</option>
                                        
                                        <option value="us">United States</option>
                                        <option value="ag">Antigua and Barbuda</option>-->
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="sysCommission">PG-Sterling Commission</label>
                                    <input type="number" step="any" name="sysCommission" class="form-control" id="sysCommission" required>
                                </div>
                                <div class="form-group">
                                    <label for="senderCommission">Sender Commission</label>
                                    <input type="number" step="any" name="senderCommission" class="form-control" id="senderCommission" required>
                                </div>
                                <div class="form-group">
                                    <label for="recipientCommission">Recipient Commission</label>
                                    <input type="number" step="any" name="recipientCommission" class="form-control" id="recipientCommission" required>
                                </div>
                                <button type="submit" class="btn-block btn btn-primary" name="add-pricing">Add New Pricing</button>
                            </form>
                        </div>

                        <?php
                    }
                    ?>
                </div>
            </div>
            <div class="col-md-8">
                <div class="box box-success">
                    <div class="box-header with-border">List of Service Pricing</div>
                    <div class="box-body">
                        <table class="table table-striped" id="pricing_policy">
                            <thead>
                            <tr>
                                <th>ID</th>
                                <th>Service Type</th>
                                <th>Sender Group</th>
                                <th>Recipient Group</th>
                                <th>Sender AccType</th>
                                <th>Recipient AccType</th>
                                <th>Price Type</th>
                                <th>Price</th>
                                <th>senderCountry</th>
                                <th>recipientCountry</th>
                                <th>sysCommission</th>
                                <th>senderCommission</th>
                                <th>recipientCommission</th>
                                <th>Edit</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<?php include "template/footer.php"?>


