<?php
include "config/init.php";
include "template/header.php";
//Main Header
include "template/main-header.php";
//Left side column. contains the logo and sidebar -->
include "template/main-sidebar.php";
?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Dashboard
            <small>Version 2.0</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Dashboard</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-8">
                <div class="panel panel-default">

                    <div class="panel-body">
                        <form role="form" method="get">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="startDate">Start Date:</label>
                                        <input type="text" class="form-control" required id="startDate" name="startDate">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="endDate">End Date:</label>
                                        <input type="text" class="form-control" required id="endDate" name="endDate">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="transType">Transaction Type</label>
                                        <select class="form-control" required id="transType" name="transType">
                                            <option value="ALL">ALL</option>
                                            <option value="MT">MT</option>
                                            <option value="MP">MP</option>
                                            <option value="CO">CO</option>
                                            <option value="BP">BP</option>
                                            <option value="TOKEN">TOKEN</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="status">Status</label>
                                        <select class="form-control" required id="status" name="status">
                                            <option value="COMPLETED">COMPLETED</option>
                                            <option value="PROCESSING">PROCESSING</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <button type="submit" name="search" class="btn btn-success btn-block">Search</button>
                        </form>
                    </div>
                </div>

                <!-- List search data -->
                <div class="box box-default">

                </div>
            </div>
            <div class="col-md-4"></div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="box box-danger">
                    <div class="box-header with-border">Main Transactions</div>
                    <div class="box-body">
                        <table class="table table-striped" id="t7">
                            <thead>
                            <tr>
                                <th>No.</th>
                                <th>Date Time</th>
                                <th>Sender</th>
                                <th>Sender country</th>
                                <th>Recipient</th>
                                <th>Recipient Country</th>
                                <th>trans Type</th>
                                <th>Sender Amount</th>
                                <th>Recipient Amount</th>
                                <th>Fee</th>
                                <th>Status</th>
                                <th>Transaction ID</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php
                            if(isset($_GET['search'])) {
                                $startDate = html_filter($dbc, $_GET['startDate']);
                                $endDate = html_filter($dbc, $_GET['endDate']);
                                $transType = html_filter($dbc, $_GET['transType']);
                                $status = html_filter($dbc, $_GET['status']);
                                if (!empty($startDate) AND !empty($endDate)) {
                                    $number = 1;
                                    if($transType == 'ALL'){
                                        $q = mysqli_query($dbc, "SELECT * FROM maintransaction_tbl WHERE (DATE(dateTime) BETWEEN '$startDate' AND '$endDate') AND transactionStatus = '$status'");

                                    } else{
                                        $q = mysqli_query($dbc, "SELECT * FROM maintransaction_tbl WHERE (DATE(dateTime) BETWEEN '$startDate' AND '$endDate') AND transactionStatus = '$status' AND transactionTypes = '$transType'");
                                    }
                                    while ($data = mysqli_fetch_assoc($q)) {
                                        $senderData = get_customer_by_id($dbc,$data['senderID']);
                                        $recipientData = get_customer_by_id($dbc,$data['recipientID']);
                                        ?>
                                        <tr>
                                            <td><?= $number ?></td>
                                            <td><?= $data['dateTime'] ?></td>
                                            <td><?= $senderData['fullName']." ".$senderData['companyName'] ?></td>
                                            <td><?= $data['senderCountryCode'] ?></td>
                                            <td><?= $recipientData['fullName']." ".$recipientData['companyName'] ?></td>
                                            <td><?= $data['recipientCountryCode'] ?></td>
                                            <td><?= $data['transactionTypes'] ?></td>
                                            <td><?= moneyFormat($data['sendersAmount']) ?></td>
                                            <td><?= moneyFormat($data['recipientAmount']) ?></td>
                                            <td><?= moneyFormat($data['fee']) ?></td>
                                            <td><?= $data['transactionStatus'] ?></td>
                                            <td><?= $data['transaction_uid'] ?></td>
                                        </tr>
                                        <?php
                                        $number++;
                                    }
                                }
                            }
                            ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<?php include "template/footer.php"?>


