<?php
include "config/init.php";
include "template/header.php";
//Main Header
include "template/main-header.php";
//Left side column. contains the logo and sidebar -->
include "template/main-sidebar.php";

// add new service pricing
if(isset($_POST['add-service'])){
    $countryCode = html_filter($dbc,$_POST['countryCode']);
    $general_service = html_filter($dbc,$_POST['general']);
    $serviceName = html_filter($dbc,$_POST['serviceName']);
    $minimum = html_filter($dbc,$_POST['minimum']);
    $maximum = html_filter($dbc,$_POST['maximum']);
    if(!empty($countryCode) && !empty($general_service) && !empty($serviceName) && !empty($minimum) && !empty($maximum)){
        if(add_new_service_pricing($dbc,$countryCode,$general_service,$serviceName,$minimum,$maximum)){
            $result = "<p class='alert alert-success'>New Service Added</p>";
        }else{
            $result = "<p class='alert alert-danger'>Error!, Please try Later</p>";
        }
    } else{
        $result = "<p class='alert alert-danger'>All Fields Required</p>";
    }
}

// Update service pricing
if(isset($_POST['update-service'])){
    $countryCode = html_filter($dbc,$_POST['countryCode']);
    $general_service = html_filter($dbc,$_POST['general']);
    $serviceName = html_filter($dbc,$_POST['serviceName']);
    $minimum = html_filter($dbc,$_POST['minimum']);
    $maximum = html_filter($dbc,$_POST['maximum']);
    if(!empty($countryCode) && !empty($general_service) && !empty($serviceName) && !empty($minimum) && !empty($maximum)){
        if(edit_new_service_pricing($dbc,$_GET['edit_service'],$countryCode,$general_service,$serviceName,$minimum,$maximum)){
            $result = "<p class='alert alert-success'>Service Updated</p>";
        } else{
            $result = "<p class='alert alert-danger'>Error!, Please try Later</p>";
        }
    } else{
        $result = "<p class='alert alert-danger'>All Fields Required</p>";
    }
}
// Edit service Pricing
if(isset($_GET['edit_service'])){
    $service_data = get_service_pricing_by_id($dbc,$_GET['edit_service']);
    if($service_data['id'] == ''){
        header("Location:service-pricing.php");
        die();
    }
}


?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Service Pricing
        </h1>
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Service Pricing</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <?php if(isset($result)){echo $result;} ?>
        <div class="row">
            <div class="col-md-4">
                <div class="box box-primary">
                        <?php
                            if(isset($_GET['edit_service'])){
                        ?>
                    <div class="box-header with-border">update Services</div>
                    <div class="box-body">
                        <form role="form" method="post">
                            <div class="form-group">
                                <label for="countryCode">Country Code</label>
                                <select id="countryCode" class="form-control" name="countryCode" required>
                                    <option value="<?=$service_data['senderCountry']?>"><?=strtoupper($service_data['senderCountry'])?></option>
                                    <option value="gb">GB</option>
                                    <option value="gh">GH</option>
                                    <option value="us">US</option>
                                    <option value="lr">LR</option>
                                    <!--<option value="lr1">LR1</option>
                                    <option value="ag">AG</option>-->
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="general">General Services</label>
                                <select id="general" class="form-control" name="general" required>
                                    <option value="<?=$service_data['general_service']?>"><?=$service_data['general_service']?></option>
                                    <option value="MT-MOMO">Money Transfer</option>
                                    <option value="TOKEN">Token</option>
                                    <option value="MT-BAK">Bank Deposit</option>
                                    <option value="MT-MOMO">Mobile Money</option>
                                    
                                    <!--<option value="MP">Make Payment</option>
                                    <option value="CO">Cash Out</option>
                                    <option value="BP">Bill Payment</option>
                                    
                                    <option value="RP">Roaming Payment</option>
                                    <option value="WTB">Wallet to Bank</option>
                                    <option value="BTW">Bank to Wallet</option>-->
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="serviceName">Service Name</label>
                                <input type="text" name="serviceName" value="<?=$service_data['serviceName']?>" class="form-control" id="serviceName" required>
                            </div>
                            <div class="form-group">
                                <label for="minimum">Minimum Amount</label>
                                <input type="number" step="any" name="minimum" value="<?=$service_data['minimum']?>" class="form-control" id="minimum" required>
                            </div>
                            <div class="form-group">
                                <label for="maximum">Maximum Amount</label>
                                <input type="number" step="any" name="maximum" value="<?=$service_data['maximum']?>" class="form-control" id="maximum" required>
                            </div>
                            <button type="submit" class="btn-block btn btn-primary" name="update-service">Update Service</button>
                        </form>
                    </div>
                        <?php
                            } else{
                        ?>
                    <div class="box-header with-border">Add New Services</div>
                    <div class="box-body">
                        <form role="form" method="post">
                                <div class="form-group">
                                    <label for="countryCode">Country Code</label>
                                    <select id="countryCode" class="form-control" name="countryCode" required>
                                        <option value="">Select Country Code</option>

                                        <option value="gb">Great Britain </option>
                                        <option value="gh">Ghana</option>
                                        <option value="lr">Liberia USD</option>
                                        <!--<option value="lr1">Liberia LRD</option>
                                        <option value="us">United States</option>
                                        <option value="ag">Antigua and Barbuda</option>-->                                    
                                        </select>
                                </div>
                                <div class="form-group">
                                    <label for="general">General Services</label>
                                    <select id="general" class="form-control" name="general" required>
                                        <option value="">Select General Service</option>
                                        <option value="MT-MOMO">Money Transfer</option>
                                    <option value="TOKEN">Token</option>
                                    <option value="MT-BANK">Bank Deposit</option>
                                    <option value="MT-MOMO">Mobile Money</option>
                                    
                                    <!--<option value="MP">Make Payment</option>
                                    <option value="CO">Cash Out</option>
                                    <option value="BP">Bill Payment</option>
                                    
                                    <option value="RP">Roaming Payment</option>
                                    <option value="WTB">Wallet to Bank</option>
                                    <option value="BTW">Bank to Wallet</option>-->
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="serviceName">Service Name</label>
                                    <input type="text" name="serviceName" class="form-control" id="serviceName" required>
                                </div>
                                <div class="form-group">
                                    <label for="minimum">Minimum Amount</label>
                                    <input type="number" step="any" name="minimum" class="form-control" id="minimum" required>
                                </div>
                                <div class="form-group">
                                    <label for="maximum">Maximum Amount</label>
                                    <input type="number" step="any" name="maximum" class="form-control" id="maximum" required>
                                </div>

                                <button type="submit" class="btn-block btn btn-primary" name="add-service">Add New Service</button>
                            </form>
                    </div>

                        <?php
                            }
                        ?>
                </div>
            </div>
            <div class="col-md-8">
                <div class="box box-success">
                    <div class="box-header with-border">List of Service Pricing</div>
                    <div class="box-body">
                        <table class="table table-striped" id="service_pricing">
                            <thead>
                            <tr>
                                <th>ID</th>
                                <th>Country</th>
                                <th>General Service</th>
                                <th>Service Name</th>
                                <th>Minimum</th>
                                <th>Maximum</th>
                                <th>Added By</th>
                                <th>Date</th>
                                <th>Edit</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<?php include "template/footer.php"?>


