<?php
include "config/init.php";
include "template/header.php";
//Main Header
include "template/main-header.php";
//Left side column. contains the logo and sidebar -->
include "template/main-sidebar.php";
//add New Super Agent && !empty($_POST['companyName']) && !empty($_POST['companyRegNum']) && !empty($_POST['companyRegDate']) && !empty($_POST['address'] && !empty($_POST['superType'])
if(isset($_POST['add_superAgent'])){
    if(!empty($_POST['phoneNum']) && !empty($_POST['phoneNum']) && !empty($_POST['password']) && !empty($_POST['country']) && !empty($_POST['c_password']) && !empty($_POST['fullName']) ){
        $phoneNum = html_filter($dbc,$_POST['phoneNum']);
        $password = $_POST['password'];
        $c_password = $_POST['c_password'];
        $fullName = html_filter($dbc,$_POST['fullName']);
        $accountType = html_filter($dbc,$_POST['accountType']);
		
        $companyName = "SYSTEM";  //html_filter($dbc,$_POST['companyName']);
        $companyRegNum = "SYSTEM";  //html_filter($dbc,$_POST['companyRegNum']);
        $companyRegDate = date("Y-m-d");  //html_filter($dbc,$_POST['companyRegDate']);
        $address = "SYSTEM";  //html_filter($dbc,$_POST['address']);
        $superType = "A";  //html_filter($dbc,$_POST['superType']);
		
		$country = html_filter($dbc,$_POST['country']);
        $is_external = 1;

        if($password == $c_password){
            $password = passwordHash($password,$mySalt);
            if(check_if_number_exist($dbc,$phoneNum)){
                $result = "<p class='alert alert-danger'>Number Already Exist..</p>";
            } else{
                if(add_new_super_agent($dbc,$phoneNum,$fullName,$password,$companyName,$companyRegNum,$companyRegDate,$address,$country,$accountType,$superType,$is_external)){
                    $result = "<p class='alert alert-success' style='margin-left:20px;margin-right:20px'>A new system account created successfully</p>";
                }else{
                    $result = "<p class='alert alert-danger' style='margin-left:20px;margin-right:20px'>An Error Occured.</p>";
                }
            }
        } else{
            $result = "<p class='alert alert-danger' style='margin-left:20px;margin-right:20px'>Passwords do not match</p>";
        }

    } else{
        $result = "<p class='alert alert-danger' style='margin-left:20px;margin-right:20px'>All fields Required</p>";
    }
}


?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            System Accounts Setup
        </h1>
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Dashboard</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <?php
                if (isset($result)){ echo $result; }
            ?>
            <div class="col-md-5">
                <div class="box box-default">
                    <div class="box-header with-border">Add New System Account</div>
                    <div class="box-body">
                        <form role="form" method="post">
                            <div class="form-group">
                                <label for="phoneNum">Phone Number</label>
                                <input type="number" minlength="10" name="phoneNum" required class="form-control" id="phoneNum" placeholder="Eg. 0XXXXXXXXXX">
                            </div>
                            <div class="form-group">
                                <label for="password">Password</label>
                                <input type="password" name="password" required class="form-control" id="password" >
                            </div>
                            <div class="form-group">
                                <label for="c_password">Confirm Password</label>
                                <input type="password" name="c_password" required class="form-control" id="c_password" >
                            </div>
                            <div class="form-group">
                                <label for="fullName">Full Name</label>
                                <input type="text" name="fullName" required class="form-control" id="fullName" >
                            </div>
                            <div class="form-group">
                                <label for="accountType">Account Type</label>
                                <select class="form-control" required id="accountType" name="accountType" >
                                    <option value="">Select Account Type</option>
                                    <option value="4">Super Agent</option>
                                    <option value="5">Customer Service</option>
                                </select>
                            </div>
                           <!-- <div class="form-group">
                                <label for="superType">Super Type</label>
                                <select class="form-control" required id="superType" name="superType" >
                                    <option value="">Select Super Type</option>
                                    <option value="A">A</option>
                                    <option value="B">B</option>
                                    <option value="B1">B1</option>
                                    <option value="C">C</option>
                                    <option value="D">D</option>
                                    <option value="E">E</option>
                                    <option value="H">H</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="is_external">is_external</label>
                                <select class="form-control" required id="is_external" name="is_external" >
                                    <option value="">Select External</option>
                                    <option value="0">0</option>
                                    <option value="1">1</option>
                                </select>
                                <small>Select 0, If user is not a GN Bank Super Agent in Ghana</small>
                            </div>
                            <div class="form-group">
                                <label for="companyName">Company Name</label>
                                <input type="text" name="companyName" required class="form-control" id="companyName" >
                            </div>
                            <div class="form-group">
                                <label for="companyRegNum">Company Registration Number</label>
                                <input type="text" name="companyRegNum" required class="form-control" id="companyRegNum" >
                            </div>
                            <div class="form-group">
                                <label for="companyRegDate">Company Registration Date</label>
                                <input type="text" name="companyRegDate" required class="form-control" id="companyRegDate" >
                            </div>
                            <div class="form-group">
                                <label for="address">Address</label>
                                <input type="text" name="address" required class="form-control" id="address" >
                            </div>-->
                            <div class="form-group">
                                <label for="country">Country</label>
                                <select class="form-control" id="country" name="country" required>
                                    <option value="">Select Country</option>
                                    <?php
                                        $countryData = get_system_country($dbc);
                                        foreach ($countryData as $country){
                                            echo "<option value='{$country['countryCode']}'>{$country['countryName']}</option>";
                                        }
                                        ?>
                                </select>
                            </div>
                            <button type="submit" class="btn btn-primary" name="add_superAgent">Add System Account</button>
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-md-7">
                <div class="box box-success">
                    <div class="box-body">
                        <table class="table" role="table" id="superAgentList">
                            <thead>
                            <th>id</th>
                            <th>Country</th>
                            <th>Phone</th>
                            <th>Company Name</th>
                            <th>Group</th>
                            <th>dateTime</th>
                            <th>Status</th>
                            <th>Action</th>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<?php include "template/footer.php"?>


