<?php
include "config/init.php";
include "template/header.php";
//Main Header
include "template/main-header.php";
//Left side column. contains the logo and sidebar -->
include "template/main-sidebar.php";

if($_SESSION['role'] != 'SYSTEMADMIN'){
    header("location:index.php");
    exit();
}


if(isset($_POST['save'])){
    $status = html_filter($dbc,$_POST['status']);
    $serviceType = html_filter($dbc,$_POST['serviceType']);
    if(!empty($status) AND !empty($serviceType)){
        if(update_system_status($dbc,$serviceType,$status)){
            $result = '<p class="alert alert-success">Service Status Updated</p>';
        }else{
            $result = '<p class="alert alert-danger">An error occur</p>';
        }
    }else{
        $result = '<p class="alert alert-danger">Please Select an option</p>';
    }
}

$ussd_status = get_system_status_by_serviceType($dbc,'USSD');
$app_status = get_system_status_by_serviceType($dbc,'APP');
$super_status = get_system_status_by_serviceType($dbc,'SUPER');
$hub_status = get_system_status_by_serviceType($dbc,'HUBTEL');
$sms_option = get_system_status_by_serviceType($dbc,'SMS-OPTION');
$bank_status = get_system_status_by_serviceType($dbc,'BANK');

?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                System Set Up
            </h1>
            <ol class="breadcrumb">
                <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
                <li class="active">System</li>
            </ol>
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-md-6">
                    <?php
                        if(isset($result)){echo $result;}
                    ?>
                    <!-- USSD status -->
                    <div class="panel panel-default">
                        <div class="panel-heading">USSD STATUS</div>
                        <div class="panel-body">
                            <form class="form-inline" method="post">
                                <label class="radio-inline">
                                    <input type="radio" name="status" id="ussd_status" value="ON" <?php if($ussd_status['status'] == 'ON'){echo 'checked';}?> > TURN ON
                                </label>
                                <label class="radio-inline">
                                    <input type="radio" name="status" id="ussd_status" value="OFF" <?php if($ussd_status['status'] == 'OFF'){echo 'checked';}?> > TURN OFF
                                </label>
                                <label class="radio-inline">
                                    <input type="hidden" value="USSD" name="serviceType">
                                    <button type="submit" class="btn btn-primary btn-sm" name="save">SAVE</button>
                                </label>
                            </form>
                        </div>
                    </div>
                    <!-- APP status -->
                    <div class="panel panel-default">
                        <div class="panel-heading">APP STATUS</div>
                        <div class="panel-body">
                            <form class="form-inline" method="post">
                                <label class="radio-inline">
                                    <input type="radio" name="status" id="app_status" value="ON" <?php if($app_status['status'] == 'ON'){echo 'checked';}?> > TURN ON
                                </label>
                                <label class="radio-inline">
                                    <input type="radio" name="status" id="app_status" value="OFF" <?php if($app_status['status'] == 'OFF'){echo 'checked';}?> > TURN OFF
                                </label>
                                <label class="radio-inline">
                                    <input type="hidden" value="APP" name="serviceType">
                                    <button type="submit" class="btn btn-primary btn-sm" name="save">SAVE</button>
                                </label>
                            </form>
                        </div>
                    </div>
                    <!-- Super Agent status -->
                    <div class="panel panel-default">
                        <div class="panel-heading">SUPER AGENT STATUS</div>
                        <div class="panel-body">
                            <form class="form-inline" method="post">
                                <label class="radio-inline">
                                    <input type="radio" name="status" id="super_status" value="ON" <?php if($super_status['status'] == 'ON'){echo 'checked';}?> > TURN ON
                                </label>
                                <label class="radio-inline">
                                    <input type="radio" name="status" id="super_status" value="OFF" <?php if($super_status['status'] == 'OFF'){echo 'checked';}?> > TURN OFF
                                </label>
                                <label class="radio-inline">
                                    <input type="hidden" value="SUPER" name="serviceType">
                                    <button type="submit" class="btn btn-primary btn-sm" name="save">SAVE</button>
                                </label>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="panel panel-default">
                        <div class="panel-heading">HUBTEL STATUS</div>
                        <div class="panel-body">
                            <form class="form-inline" method="post">
                                <label class="radio-inline">
                                    <input type="radio" name="status" id="hubtel_status" value="ON" <?php if($hub_status['status'] == 'ON'){echo 'checked';}?> > TURN ON
                                </label>
                                <label class="radio-inline">
                                    <input type="radio" name="status" id="hubtel_status" value="OFF" <?php if($hub_status['status'] == 'OFF'){echo 'checked';}?> > TURN OFF
                                </label>
                                <label class="radio-inline">
                                    <input type="hidden" value="HUBTEL" name="serviceType">
                                    <button type="submit" class="btn btn-primary btn-sm" name="save">SAVE</button>
                                </label>
                            </form>
                        </div>
                    </div>

                    <!-- SMS Options -->
                    <div class="panel panel-default">
                        <div class="panel-heading">SMS OPTIONS</div>
                        <div class="panel-body">
                            <form class="form-inline" method="post">
                                <label class="radio-inline">
                                    <input type="radio" name="status" id="sms_option" value="INFOBIP" <?php if($sms_option['status'] == 'INFOBIP'){echo 'checked';}?> > INFOBIP
                                </label>
                                <label class="radio-inline">
                                    <input type="radio" name="status" id="sms_option" value="ROUTER" <?php if($sms_option['status'] == 'ROUTER'){echo 'checked';}?> > ROUTER
                                </label>
                                <label class="radio-inline">
                                    <input type="radio" name="status" id="sms_option" value="TWILIO" <?php if($sms_option['status'] == 'TWILIO'){echo 'checked';}?> > TWILIO
                                </label>
                                <label class="radio-inline">
                                    <input type="hidden" value="SMS-OPTION" name="serviceType">
                                    <button type="submit" class="btn btn-primary btn-sm" name="save">SAVE</button>
                                </label>
                            </form>
                        </div>
                    </div>

                    <!-- Bank Services -->
                    <div class="panel panel-default">
                        <div class="panel-heading">BANK STATUS</div>
                        <div class="panel-body">
                            <form class="form-inline" method="post">
                                <label class="radio-inline">
                                    <input type="radio" name="status" id="bank_status" value="ON" <?php if($bank_status['status'] == 'ON'){echo 'checked';}?> > TURN ON
                                </label>
                                <label class="radio-inline">
                                    <input type="radio" name="status" id="bank_status" value="OFF" <?php if($bank_status['status'] == 'OFF'){echo 'checked';}?> > TURN OFF
                                </label>
                                <label class="radio-inline">
                                    <input type="hidden" value="BANK" name="serviceType">
                                    <button type="submit" class="btn btn-primary btn-sm" name="save">SAVE</button>
                                </label>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?php include "template/footer.php"?>


