<?php
include "config/init.php";
include "system/bank/bank-index.php";
include "system/bank_test/lr_func_bank_api.php";
include "template/header.php";
//Main Header
include "template/main-header.php";
//Left side column. contains the logo and sidebar -->
include "template/main-sidebar.php";

if(isset($_POST['creditCustomer'])){
    $transaction_uid = html_filter($dbc,$_POST['transaction_uid']);
    $transactionType = "BTW";
    $comment = "Bank to wallet Error";

    if(!empty($transaction_uid)){
        if(check_if_transaction_uid_exist_at_bank_transaction($dbc,$transaction_uid)) {
            $transactionData = get_bank_transaction_by_transaction_uid($dbc,$transaction_uid);
            $amount = $transactionData['recipientAmount'];
            $findCustomer = $transactionData['recipientID'];
            $customerData = get_customer_by_id($dbc,$findCustomer);

            if($transactionType == $transactionData['transactionTypes']) {
                if (redraw_funds($dbc, $transactionData['senderID'], $amount)) {
                    if (add_funds($dbc, $findCustomer, $amount)) {
                        if (update_bank_transaction_after_success($dbc, $transaction_uid, '')) {
                            $q = mysqli_query($dbc, "INSERT INTO transitResolver_tbl (id, customerID, amount, transaction_uid, transactionType, comment, user_id) VALUES 
                          (UUID(),'$findCustomer','$amount','$transaction_uid','$transactionType','$comment','$_SESSION[uid]')
                        ");
                            if ($q) {

                                if ($customerData['accountType'] == 2 AND $customerData['accountType'] == 4) {
                                    $senderAcc = get_cus_account_info_by_customerID($dbc, $transactionData['senderID']);
                                    $recipientAcc = get_cus_account_info_by_customerID($dbc, $transactionData['recipientID']);
                                    if (update_bank_transaction_balance_and_complete($dbc, $transaction_uid, $recipientAcc['balance'], $senderAcc['balance'])) {
                                        $result = "<p class='alert alert-success'>You have sent {$amount} to a customer by the name {$customerData['fullName']} {$customerData['companyName']}</p>";
                                        $message = "Your account have been credited with an amount of {$amount} from GN Money/PayGlobal(Bank to Wallet). transaction ID: {$transaction_uid} ";
                                        sendSMS($customerData['phoneNum'], $message);
                                    }
                                } else {
                                    $all_transactionData = get_bank_transaction_by_transaction_uid($dbc, $transaction_uid);
                                    if (redraw_funds($dbc, $findCustomer, $all_transactionData['fee'])) {
                                        $all_transactionData['senderID'] = $all_transactionData['recipientID'];
                                        $all_transactionData['senderCountryCode'] = 'lr';
                                        $all_transactionData['transactionTypes'] = $all_transactionData['serviceType'];
                                        if (add_payGlobal_commission($dbc, $all_transactionData, $all_transactionData['fee'])) {

                                            $senderAcc = get_cus_account_info_by_customerID($dbc, $transactionData['senderID']);
                                            $recipientAcc = get_cus_account_info_by_customerID($dbc, $transactionData['recipientID']);
                                            if (update_bank_transaction_balance_and_complete($dbc, $transaction_uid, $recipientAcc['balance'], $senderAcc['balance'])) {


                                                $result = "<p class='alert alert-success'>You have sent {$amount} to a customer by the name {$customerData['fullName']} {$customerData['companyName']}</p>";
                                                $message = "Your account have been credited with an amount of {$amount} from GN Money/PayGlobal (Bank to Wallet). transaction ID: {$transaction_uid} ";
                                                sendSMS($customerData['phoneNum'], $message);
                                            }
                                        } else {
                                            $result = "<p class='alert alert-danger'> Error adding fees to payGlobal commission..</p>";
                                        }
                                    } else {
                                        $result = "<p class='alert alert-danger'>Error Redrawing fees..</p>";
                                    }
                                }

                            } else {
                                $result = "<p class='alert alert-danger'>System Error..</p>";

                            }

                        } else {
                            $result = "<p class='alert alert-danger'>System Error occur..</p>";

                        }
                    } else {
                        $result = "<p class='alert alert-danger'>Can't Add funds to customer</p>";
                    }
                } else {
                    $result = "<p class='alert alert-danger'>No funds in Transit Account</p>";

                }
            }else{
                $result = "<p class='alert alert-danger'>Transaction Type Not the same</p>";
            }
        } else{
            $result = "<p class='alert alert-danger'>Transaction ID does not exist</p>";
        }
    } else{
        $result = "<p class='alert alert-danger'>All fields required</p>";
    }

}

?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Bank To Wallet Resolver
        </h1>
    </section>

    <!-- Main content -->
    <section class="content">
        <?php
            if(isset($result)){echo $result;}
        ?>
        <div class="row">
            <div class="col-md-4">
                <div class="box box-default">
                    <div class="box-header with-border">Credit Customer Account From Transit if bank failed.</div>
                    <div class="box-body">
                        <form method="post" role="form" onsubmit="return confirm('Are you sure you want to do this transaction');">

                            <div class="form-group">
                                <label for="transaction_uid">Transaction ID</label>
                                <input type="text" name="transaction_uid" id="transaction_uid" required class="form-control">
                            </div>
                            <button class="btn btn-primary" name="creditCustomer" type="submit" id="creditCustomer">Credit Customer</button>

                        </form>
                    </div>
                </div>
            </div>
            <div class="col-md-8">
                <div class="box box-success">
                    <div class="box-header with-border">List of Bank Resolve Issues Account</div>
                    <div class="box-body">
                        <table class="table table-striped" id="list-transit-resolver">
                            <thead>
                            <tr>
                                <th>Date</th>
                                <th>customer</th>
                                <th>Amount</th>
                                <th>Transaction ID</th>
                                <th>Transaction TYPE</th>
                                <th>Comment</th>
                                <th>User</th>
                            </tr>
                            </thead>

                        </table>
                    </div>
                </div>



            </div>
        </div>
    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<?php include "template/footer.php"?>


